/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.typeserializers;

import com.google.common.reflect.TypeToken;
import java.util.LinkedHashMap;
import java.util.Map;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.objectmapping.ObjectMappingException;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializer;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public final class BukkitTypeSerializer
implements TypeSerializer<ConfigurationSerializable> {
    private static final TypeToken<Map<String, Object>> TYPE = new TypeToken<Map<String, Object>>(){};
    public static final BukkitTypeSerializer INSTANCE = new BukkitTypeSerializer();

    private BukkitTypeSerializer() {
    }

    @Override
    public ConfigurationSerializable deserialize(TypeToken<?> type, ConfigurationNode from) throws ObjectMappingException {
        Map<String, Object> map = from.getValue(TYPE);
        BukkitTypeSerializer.deserializeChildren(map);
        return ConfigurationSerialization.deserializeObject(map);
    }

    @Override
    public void serialize(TypeToken<?> type, ConfigurationSerializable from, ConfigurationNode to) throws ObjectMappingException {
        Map serialized = from.serialize();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(serialized.size() + 1);
        map.put("==", ConfigurationSerialization.getAlias(from.getClass()));
        map.putAll(serialized);
        to.setValue(map);
    }

    private static void deserializeChildren(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                try {
                    Map value = (Map)entry.getValue();
                    BukkitTypeSerializer.deserializeChildren(value);
                    if (value.containsKey("==")) {
                        entry.setValue(ConfigurationSerialization.deserializeObject((Map)value));
                    }
                }
                catch (Exception value) {
                    // empty catch block
                }
            }
            if (!(entry.getValue() instanceof Number)) continue;
            double doubleVal = ((Number)entry.getValue()).doubleValue();
            int intVal = (int)doubleVal;
            long longVal = (long)doubleVal;
            if ((double)intVal == doubleVal) {
                entry.setValue(intVal);
                continue;
            }
            if ((double)longVal == doubleVal) {
                entry.setValue(longVal);
                continue;
            }
            entry.setValue(doubleVal);
        }
    }
}

