/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.objectmapping;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.commented.CommentedConfigurationNode;
import me.lucko.helper.config.objectmapping.DefaultObjectMapperFactory;
import me.lucko.helper.config.objectmapping.ObjectMappingException;
import me.lucko.helper.config.objectmapping.Setting;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ObjectMapper<T> {
    private final Class<T> clazz;
    private final Constructor<T> constructor;
    private final Map<String, FieldData> cachedFields = new HashMap<String, FieldData>();

    public static <T> ObjectMapper<T> forClass(@NonNull Class<T> clazz) throws ObjectMappingException {
        return DefaultObjectMapperFactory.getInstance().getMapper(clazz);
    }

    public static <T> BoundInstance forObject(@NonNull T obj) throws ObjectMappingException {
        Preconditions.checkNotNull(obj);
        return ObjectMapper.forClass(obj.getClass()).bind(obj);
    }

    protected ObjectMapper(Class<T> clazz) throws ObjectMappingException {
        this.clazz = clazz;
        Constructor<T> constructor = null;
        try {
            constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.constructor = constructor;
        Class<T> collectClass = clazz;
        do {
            this.collectFields(this.cachedFields, collectClass);
        } while (!(collectClass = collectClass.getSuperclass()).equals(Object.class));
    }

    protected void collectFields(Map<String, FieldData> cachedFields, Class<? super T> clazz) throws ObjectMappingException {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Setting.class)) continue;
            Setting setting = field.getAnnotation(Setting.class);
            String path = setting.value();
            if (path.isEmpty()) {
                path = field.getName();
            }
            FieldData data = new FieldData(field, setting.comment());
            field.setAccessible(true);
            if (cachedFields.containsKey(path)) continue;
            cachedFields.put(path, data);
        }
    }

    protected T constructObject() throws ObjectMappingException {
        if (this.constructor == null) {
            throw new ObjectMappingException("No zero-arg constructor is available for class " + this.clazz + " but is required to construct new instances!");
        }
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ObjectMappingException("Unable to create instance of target class " + this.clazz, e);
        }
    }

    public boolean canCreateInstances() {
        return this.constructor != null;
    }

    public BoundInstance bind(T instance) {
        return new BoundInstance(instance);
    }

    public BoundInstance bindToNew() throws ObjectMappingException {
        return new BoundInstance(this.constructObject());
    }

    public Class<T> getMappedType() {
        return this.clazz;
    }

    public class BoundInstance {
        private final T boundInstance;

        protected BoundInstance(T boundInstance) {
            this.boundInstance = boundInstance;
        }

        public T populate(ConfigurationNode source) throws ObjectMappingException {
            for (Map.Entry ent : ObjectMapper.this.cachedFields.entrySet()) {
                ConfigurationNode node = source.getNode(ent.getKey());
                ((FieldData)ent.getValue()).deserializeFrom(this.boundInstance, node);
            }
            return this.boundInstance;
        }

        public void serialize(ConfigurationNode target) throws ObjectMappingException {
            for (Map.Entry ent : ObjectMapper.this.cachedFields.entrySet()) {
                ConfigurationNode node = target.getNode(ent.getKey());
                ((FieldData)ent.getValue()).serializeTo(this.boundInstance, node);
            }
        }

        public T getInstance() {
            return this.boundInstance;
        }
    }

    protected static class FieldData {
        private final Field field;
        private final TypeToken<?> fieldType;
        private final String comment;

        public FieldData(Field field, String comment) throws ObjectMappingException {
            this.field = field;
            this.comment = comment;
            this.fieldType = TypeToken.of((Type)field.getGenericType());
        }

        public void deserializeFrom(Object instance, ConfigurationNode node) throws ObjectMappingException {
            TypeSerializer<?> serial = node.getOptions().getSerializers().get(this.fieldType);
            if (serial == null) {
                throw new ObjectMappingException("No TypeSerializer found for field " + this.field.getName() + " of type " + this.fieldType);
            }
            Object newVal = node.isVirtual() ? null : serial.deserialize(this.fieldType, node);
            try {
                if (newVal == null) {
                    Object existingVal = this.field.get(instance);
                    if (existingVal != null) {
                        this.serializeTo(instance, node);
                    }
                } else {
                    this.field.set(instance, newVal);
                }
            }
            catch (IllegalAccessException e) {
                throw new ObjectMappingException("Unable to deserialize field " + this.field.getName(), e);
            }
        }

        public void serializeTo(Object instance, ConfigurationNode node) throws ObjectMappingException {
            try {
                CommentedConfigurationNode commentNode;
                Object fieldVal = this.field.get(instance);
                if (fieldVal == null) {
                    node.setValue(null);
                } else {
                    TypeSerializer<?> serial = node.getOptions().getSerializers().get(this.fieldType);
                    if (serial == null) {
                        throw new ObjectMappingException("No TypeSerializer found for field " + this.field.getName() + " of type " + this.fieldType);
                    }
                    serial.serialize(this.fieldType, fieldVal, node);
                }
                if (node instanceof CommentedConfigurationNode && this.comment != null && !this.comment.isEmpty() && !(commentNode = (CommentedConfigurationNode)node).getComment().isPresent()) {
                    commentNode.setComment(this.comment);
                }
            }
            catch (IllegalAccessException e) {
                throw new ObjectMappingException("Unable to serialize field " + this.field.getName(), e);
            }
        }
    }
}

