/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config;

import com.google.common.base.Objects;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import me.lucko.helper.config.ConfigValue;
import me.lucko.helper.config.SimpleConfigurationNode;
import me.lucko.helper.config.ValueType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class MapConfigValue
extends ConfigValue {
    volatile ConcurrentMap<Object, SimpleConfigurationNode> values = this.newMap();

    public MapConfigValue(SimpleConfigurationNode holder) {
        super(holder);
    }

    @Override
    ValueType getType() {
        return ValueType.MAP;
    }

    private ConcurrentMap<Object, SimpleConfigurationNode> newMap() {
        return this.holder.getOptions().getMapFactory().create();
    }

    @Override
    public @Nullable Object getValue() {
        LinkedHashMap value = new LinkedHashMap();
        for (Map.Entry ent : this.values.entrySet()) {
            value.put(ent.getKey(), ((SimpleConfigurationNode)ent.getValue()).getValue());
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(@Nullable Object value) {
        if (value instanceof Map) {
            ConcurrentMap<Object, SimpleConfigurationNode> newValue = this.newMap();
            for (Map.Entry ent : ((Map)value).entrySet()) {
                if (ent.getValue() == null) continue;
                SimpleConfigurationNode child = this.holder.createNode(ent.getKey());
                newValue.put(ent.getKey(), child);
                child.attached = true;
                child.setValue(ent.getValue());
            }
            MapConfigValue mapConfigValue = this;
            synchronized (mapConfigValue) {
                ConcurrentMap<Object, SimpleConfigurationNode> oldMap = this.values;
                this.values = newValue;
                MapConfigValue.detachChildren(oldMap);
            }
        } else {
            throw new IllegalArgumentException("Map configuration values can only be set to values of type Map");
        }
    }

    @Override
    @Nullable SimpleConfigurationNode putChild(@NonNull Object key, @Nullable SimpleConfigurationNode value) {
        if (value == null) {
            return (SimpleConfigurationNode)this.values.remove(key);
        }
        return this.values.put(key, value);
    }

    @Override
    @Nullable SimpleConfigurationNode putChildIfAbsent(@NonNull Object key, @Nullable SimpleConfigurationNode value) {
        if (value == null) {
            return (SimpleConfigurationNode)this.values.remove(key);
        }
        return this.values.putIfAbsent(key, value);
    }

    @Override
    public @Nullable SimpleConfigurationNode getChild(@Nullable Object key) {
        return (SimpleConfigurationNode)this.values.get(key);
    }

    @Override
    public @NonNull Iterable<SimpleConfigurationNode> iterateChildren() {
        return this.values.values();
    }

    @Override
    @NonNull MapConfigValue copy(@NonNull SimpleConfigurationNode holder) {
        MapConfigValue copy = new MapConfigValue(holder);
        for (Map.Entry ent : this.values.entrySet()) {
            copy.values.put(ent.getKey(), ((SimpleConfigurationNode)ent.getValue()).copy(holder));
        }
        return copy;
    }

    private static void detachChildren(Map<Object, SimpleConfigurationNode> map) {
        for (SimpleConfigurationNode value : map.values()) {
            value.attached = false;
            value.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        MapConfigValue mapConfigValue = this;
        synchronized (mapConfigValue) {
            ConcurrentMap<Object, SimpleConfigurationNode> oldMap = this.values;
            this.values = this.newMap();
            MapConfigValue.detachChildren(oldMap);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapConfigValue that = (MapConfigValue)o;
        return Objects.equal(this.values, that.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        return "MapConfigValue{values=" + this.values + '}';
    }
}

