/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.text;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lucko.helper.text.Component;
import me.lucko.helper.text.TextComponent;
import me.lucko.helper.text.adapter.bukkit.TextAdapter;
import me.lucko.helper.text.serializer.ComponentSerializers;
import org.bukkit.command.CommandSender;

public final class Text {
    public static final char SECTION_CHAR = '\u00a7';
    public static final char AMPERSAND_CHAR = '&';

    public static String joinNewline(String ... strings) {
        return Text.joinNewline(Arrays.stream(strings));
    }

    public static String joinNewline(Stream<String> strings) {
        return strings.collect(Collectors.joining("\n"));
    }

    public static TextComponent fromLegacy(String input, char character) {
        return ComponentSerializers.LEGACY.deserialize(input, character);
    }

    public static TextComponent fromLegacy(String input) {
        return ComponentSerializers.LEGACY.deserialize(input);
    }

    public static String toLegacy(Component component, char character) {
        return ComponentSerializers.LEGACY.serialize(component, character);
    }

    public static String toLegacy(Component component) {
        return ComponentSerializers.LEGACY.serialize(component);
    }

    public static void sendMessage(CommandSender sender, Component message) {
        TextAdapter.sendComponent(sender, message);
    }

    public static void sendMessage(Iterable<CommandSender> senders, Component message) {
        TextAdapter.sendComponent(senders, message);
    }

    public static String colorize(String s) {
        return s == null ? null : Text.translateAlternateColorCodes('&', '\u00a7', s);
    }

    public static String decolorize(String s) {
        return s == null ? null : Text.translateAlternateColorCodes('\u00a7', '&', s);
    }

    public static String translateAlternateColorCodes(char from, char to, String textToTranslate) {
        char[] b = textToTranslate.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != from || "0123456789AaBbCcDdEeFfKkLlMmNnOoRr".indexOf(b[i + 1]) <= -1) continue;
            b[i] = to;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b);
    }

    private Text() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

