/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.npc;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.Events;
import me.lucko.helper.Schedulers;
import me.lucko.helper.metadata.ExpiringValue;
import me.lucko.helper.metadata.Metadata;
import me.lucko.helper.metadata.MetadataKey;
import me.lucko.helper.metadata.MetadataMap;
import me.lucko.helper.npc.CitizensNpc;
import me.lucko.helper.npc.Npc;
import me.lucko.helper.npc.NpcFactory;
import me.lucko.helper.terminable.composite.CompositeTerminable;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCClickEvent;
import net.citizensnpcs.api.event.NPCLeftClickEvent;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.npc.MemoryNPCDataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCDataStore;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitInfo;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.LookClose;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.server.PluginEnableEvent;

public class CitizensNpcFactory
implements NpcFactory {
    private static final MetadataKey<Boolean> RECENT_NPC_CLICK_KEY = MetadataKey.createBooleanKey("helper-recent-npc-click");
    private NPCRegistry npcRegistry;
    private final CompositeTerminable registry = CompositeTerminable.create();

    public CitizensNpcFactory() {
        Events.subscribe(PluginEnableEvent.class).filter(e -> e.getPlugin().getName().equals("Citizens")).expireAfter(1L).handler(e -> this.init());
    }

    private void init() {
        this.npcRegistry = CitizensAPI.createNamedNPCRegistry((String)"helper", (NPCDataStore)new MemoryNPCDataStore());
        CitizensNpcFactory.registerTrait();
        Events.merge(NPCClickEvent.class, NPCRightClickEvent.class, NPCLeftClickEvent.class).handler(e -> this.handleClick(e.getNPC(), e.getClicker())).bindWith(this.registry);
        Events.subscribe(PlayerFishEvent.class).filter(e -> e.getCaught() != null).filter(e -> e.getCaught().hasMetadata("NPC")).handler(e -> e.setCancelled(true)).bindWith(this.registry);
        Events.subscribe(EntityDamageByEntityEvent.class).filter(e -> e.getEntity().hasMetadata("NPC")).handler(e -> e.setCancelled(true)).bindWith(this.registry);
        Schedulers.sync().runRepeating(this::tickNpcs, 10L, 10L).bindWith(this.registry);
    }

    private void handleClick(NPC npc, Player clicker) {
        if (npc.hasTrait(ClickableTrait.class)) {
            if (this.processMetadata(clicker)) {
                return;
            }
            ((ClickableTrait)npc.getTrait(ClickableTrait.class)).onClick(clicker);
        }
    }

    private boolean processMetadata(Player p) {
        return !Metadata.provideForPlayer(p).putIfAbsent(RECENT_NPC_CLICK_KEY, ExpiringValue.of(true, 100L, TimeUnit.MILLISECONDS));
    }

    private void tickNpcs() {
        for (NPC npc : this.npcRegistry) {
            if (!npc.isSpawned() || !npc.hasTrait(ClickableTrait.class)) continue;
            Npc helperNpc = ((ClickableTrait)npc.getTrait(ClickableTrait.class)).npc;
            Location loc = npc.getEntity().getLocation();
            if (loc.getBlockX() != helperNpc.getInitialSpawn().getBlockX() || loc.getBlockZ() != helperNpc.getInitialSpawn().getBlockZ()) {
                npc.teleport(helperNpc.getInitialSpawn().clone(), PlayerTeleportEvent.TeleportCause.PLUGIN);
            }
            for (Entity entity : npc.getStoredLocation().getWorld().getNearbyEntities(npc.getStoredLocation(), 1.0, 1.0, 1.0)) {
                Player p;
                if (!(entity instanceof Player) || this.npcRegistry.isNPC(entity) || (p = (Player)entity).getGameMode() == GameMode.CREATIVE || p.getGameMode() == GameMode.SPECTATOR || !(npc.getEntity().getLocation().distance(p.getLocation()) < 3.5)) continue;
                p.setVelocity(p.getLocation().getDirection().multiply(-0.5).setY(0.4));
            }
        }
    }

    @Override
    @Nonnull
    public CitizensNpc spawnNpc(@Nonnull Location location, @Nonnull String nametag, @Nonnull String skinPlayer) {
        return this.spawnNpc(location.clone(), nametag, (Npc npc) -> npc.setSkin(skinPlayer));
    }

    @Override
    @Nonnull
    public CitizensNpc spawnNpc(@Nonnull Location location, @Nonnull String nametag, @Nonnull String skinTextures, @Nonnull String skinSignature) {
        return this.spawnNpc(location.clone(), nametag, (Npc npc) -> npc.setSkin(skinTextures, skinSignature));
    }

    private CitizensNpc spawnNpc(Location location, String nametag, Consumer<Npc> skin) {
        NPC npc = this.npcRegistry.createNPC(EntityType.PLAYER, nametag);
        ClickableTrait trait = new ClickableTrait();
        npc.addTrait((Trait)trait);
        NpcImpl helperNpc = new NpcImpl(npc, trait, location.clone());
        trait.npc = helperNpc;
        skin.accept(helperNpc);
        npc.spawn(location);
        return helperNpc;
    }

    @Override
    public void close() {
        this.npcRegistry.deregisterAll();
        this.registry.closeAndReportException();
    }

    private static void registerTrait() {
        if (CitizensAPI.getTraitFactory().getTrait(ClickableTrait.class) == null) {
            try {
                CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(ClickableTrait.class));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static final class NpcImpl
    implements CitizensNpc {
        private final NPC npc;
        private final ClickableTrait trait;
        private final Location initialSpawn;

        private NpcImpl(NPC npc, ClickableTrait trait, Location initialSpawn) {
            this.npc = npc;
            this.trait = trait;
            this.initialSpawn = initialSpawn;
        }

        @Override
        public void setClickCallback(@Nullable Consumer<Player> clickCallback) {
            this.trait.clickCallback = clickCallback;
        }

        @Override
        @Nonnull
        public MetadataMap getMeta() {
            return this.trait.meta;
        }

        @Override
        @Deprecated
        public void setSkin(@Nonnull String skinPlayer) {
            try {
                this.npc.data().set("player-skin-name", (Object)skinPlayer);
                this.npc.data().set("player-skin-use-latest-skin", (Object)true);
                if (this.npc instanceof SkinnableEntity) {
                    ((SkinnableEntity)this.npc).getSkinTracker().notifySkinChange(true);
                }
                if (this.npc.getEntity() instanceof SkinnableEntity) {
                    ((SkinnableEntity)this.npc.getEntity()).getSkinTracker().notifySkinChange(true);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Override
        public void setSkin(@Nonnull String textures, @Nonnull String signature) {
            try {
                this.npc.data().set("player-skin-textures", (Object)textures);
                this.npc.data().set("player-skin-signature", (Object)signature);
                this.npc.data().set("cached-skin-uuid-name", (Object)"null");
                this.npc.data().set("player-skin-name", (Object)"null");
                this.npc.data().set("cached-skin-uuid", (Object)UUID.randomUUID().toString());
                this.npc.data().set("player-skin-use-latest-skin", (Object)false);
                if (this.npc instanceof SkinnableEntity) {
                    ((SkinnableEntity)this.npc).getSkinTracker().notifySkinChange(true);
                }
                if (this.npc.getEntity() instanceof SkinnableEntity) {
                    ((SkinnableEntity)this.npc.getEntity()).getSkinTracker().notifySkinChange(true);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Override
        public void setName(@Nonnull String name) {
            this.npc.setName(name);
        }

        @Override
        public void setShowNametag(boolean show) {
            this.npc.data().set("nameplate-visible", (Object)show);
        }

        @Override
        @Nonnull
        public Location getInitialSpawn() {
            return this.initialSpawn;
        }

        @Override
        @Nonnull
        public NPC getNpc() {
            return this.npc;
        }
    }

    private static final class ClickableTrait
    extends Trait {
        private final MetadataMap meta = MetadataMap.create();
        private Consumer<Player> clickCallback = null;
        private Npc npc = null;

        public ClickableTrait() {
            super("helper_clickable");
        }

        public void onSpawn() {
            super.onSpawn();
            this.ensureLook((LookClose)this.getNPC().getTrait(LookClose.class));
        }

        private void ensureLook(LookClose lookTraitInstance) {
            if (lookTraitInstance.toggle()) {
                return;
            }
            lookTraitInstance.toggle();
        }

        private void onClick(Player player) {
            if (this.clickCallback != null) {
                this.clickCallback.accept(player);
            }
        }
    }
}

