/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.menu.paginated;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import me.lucko.helper.item.ItemStackBuilder;
import me.lucko.helper.menu.Gui;
import me.lucko.helper.menu.Item;
import me.lucko.helper.menu.Slot;
import me.lucko.helper.menu.paginated.PageInfo;
import me.lucko.helper.menu.paginated.PaginatedGuiBuilder;
import me.lucko.helper.menu.scheme.MenuScheme;
import me.lucko.helper.utils.annotation.NonnullByDefault;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@NonnullByDefault
public class PaginatedGui
extends Gui {
    private final MenuScheme scheme;
    private final List<Integer> itemSlots;
    private final int nextPageSlot;
    private final int previousPageSlot;
    private final Function<PageInfo, ItemStack> nextPageItem;
    private final Function<PageInfo, ItemStack> previousPageItem;
    private List<Item> content;
    private int page;

    public PaginatedGui(Function<PaginatedGui, List<Item>> content, Player player, PaginatedGuiBuilder model) {
        super(player, model.getLines(), model.getTitle());
        this.content = ImmutableList.copyOf((Collection)content.apply(this));
        this.page = 1;
        this.scheme = model.getScheme();
        this.itemSlots = ImmutableList.copyOf(model.getItemSlots());
        this.nextPageSlot = model.getNextPageSlot();
        this.previousPageSlot = model.getPreviousPageSlot();
        this.nextPageItem = model.getNextPageItem();
        this.previousPageItem = model.getPreviousPageItem();
    }

    @Override
    public void redraw() {
        Slot slot;
        ArrayList page;
        this.scheme.apply(this);
        ArrayList<Integer> slots = new ArrayList<Integer>(this.itemSlots);
        List pages = Lists.partition(this.content, (int)slots.size());
        if (this.page < 1) {
            this.page = 1;
        } else if (this.page > pages.size()) {
            this.page = Math.max(1, pages.size());
        }
        List list = page = pages.isEmpty() ? new ArrayList() : (List)pages.get(this.page - 1);
        if (this.page == 1) {
            slot = this.getSlot(this.previousPageSlot);
            slot.clearBindings();
            if (slot.hasItem() && slot.getItem().getType() == this.previousPageItem.apply(PageInfo.create(0, 0)).getType()) {
                slot.clearItem();
            }
        } else {
            this.setItem(this.previousPageSlot, ItemStackBuilder.of(this.previousPageItem.apply(PageInfo.create(this.page, pages.size()))).build(() -> {
                --this.page;
                this.redraw();
            }));
        }
        if (this.page >= pages.size()) {
            slot = this.getSlot(this.nextPageSlot);
            slot.clearBindings();
            if (slot.hasItem() && slot.getItem().getType() == this.nextPageItem.apply(PageInfo.create(0, 0)).getType()) {
                slot.clearItem();
            }
        } else {
            this.setItem(this.nextPageSlot, ItemStackBuilder.of(this.nextPageItem.apply(PageInfo.create(this.page, pages.size()))).build(() -> {
                ++this.page;
                this.redraw();
            }));
        }
        if (!this.isFirstDraw()) {
            slots.forEach(this::removeItem);
        }
        for (Item item : page) {
            int index = (Integer)slots.remove(0);
            this.setItem(index, item);
        }
    }

    public void updateContent(List<Item> content) {
        this.content = ImmutableList.copyOf(content);
    }
}

