/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.cooldown;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import me.lucko.helper.cooldown.ComposedCooldownMap;
import me.lucko.helper.cooldown.Cooldown;

class ComposedCooldownMapImpl<I, O>
implements ComposedCooldownMap<I, O> {
    private final Cooldown base;
    private final LoadingCache<O, Cooldown> cache;
    private final Function<I, O> composeFunction;

    ComposedCooldownMapImpl(final Cooldown base, Function<I, O> composeFunction) {
        this.base = base;
        this.composeFunction = composeFunction;
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(base.getTimeout() + 10000L, TimeUnit.MILLISECONDS).build(new CacheLoader<O, Cooldown>(){

            public Cooldown load(@Nonnull O key) {
                return base.copy();
            }
        });
    }

    @Override
    @Nonnull
    public Cooldown getBase() {
        return this.base;
    }

    @Override
    @Nonnull
    public Cooldown get(@Nonnull I key) {
        Objects.requireNonNull(key, "key");
        return (Cooldown)this.cache.getUnchecked(this.composeFunction.apply(key));
    }

    @Override
    public void put(@Nonnull O key, @Nonnull Cooldown cooldown) {
        Objects.requireNonNull(key, "key");
        Preconditions.checkArgument((cooldown.getTimeout() == this.base.getTimeout() ? 1 : 0) != 0, (Object)"different timeout");
        this.cache.put(key, (Object)cooldown);
    }

    @Override
    @Nonnull
    public Map<O, Cooldown> getAll() {
        return this.cache.asMap();
    }
}

