/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.utils;

import java.util.UUID;

public final class UndashedUuids {
    public static String toString(UUID uuid) {
        return UndashedUuids.digits(uuid.getMostSignificantBits() >> 32, 8) + UndashedUuids.digits(uuid.getMostSignificantBits() >> 16, 4) + UndashedUuids.digits(uuid.getMostSignificantBits(), 4) + UndashedUuids.digits(uuid.getLeastSignificantBits() >> 48, 4) + UndashedUuids.digits(uuid.getLeastSignificantBits(), 12);
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public static UUID fromString(String string) throws IllegalArgumentException {
        if (string.length() != 32) {
            throw new IllegalArgumentException("Invalid length " + string.length() + ": " + string);
        }
        try {
            return new UUID(Long.parseUnsignedLong(string.substring(0, 16), 16), Long.parseUnsignedLong(string.substring(16), 16));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid uuid string: " + string, e);
        }
    }

    private UndashedUuids() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

