/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.network.redirect;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import me.lucko.helper.Events;
import me.lucko.helper.event.SingleSubscription;
import me.lucko.helper.messaging.InstanceData;
import me.lucko.helper.messaging.Messenger;
import me.lucko.helper.messaging.conversation.ConversationChannel;
import me.lucko.helper.messaging.conversation.ConversationChannelAgent;
import me.lucko.helper.messaging.conversation.ConversationMessage;
import me.lucko.helper.messaging.conversation.ConversationReply;
import me.lucko.helper.messaging.conversation.ConversationReplyListener;
import me.lucko.helper.network.redirect.PlayerRedirector;
import me.lucko.helper.network.redirect.RedirectParameterProvider;
import me.lucko.helper.network.redirect.RedirectSystem;
import me.lucko.helper.profiles.Profile;
import me.lucko.helper.promise.Promise;
import me.lucko.helper.text3.Text;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;

public class AbstractRedirectSystem
implements RedirectSystem {
    private final InstanceData instanceData;
    private final PlayerRedirector redirector;
    private final ConversationChannel<RequestMessage, ResponseMessage> channel;
    private final ConversationChannelAgent<RequestMessage, ResponseMessage> agent;
    private final ExpiringMap<UUID, RedirectSystem.Response> expectedPlayers = ExpiringMap.builder().expiration(5L, TimeUnit.SECONDS).expirationPolicy(ExpirationPolicy.CREATED).build();
    private final SingleSubscription<AsyncPlayerPreLoginEvent> loginEventListener;
    private boolean ensureJoinedViaQueue = true;
    private RedirectSystem.RequestHandler handler = new AllowAllHandler();
    private final List<RedirectParameterProvider> defaultParameters = new CopyOnWriteArrayList<RedirectParameterProvider>();

    public AbstractRedirectSystem(Messenger messenger, InstanceData instanceData, PlayerRedirector redirector) {
        this.instanceData = instanceData;
        this.redirector = redirector;
        this.channel = messenger.getConversationChannel("hlp-redirect", RequestMessage.class, ResponseMessage.class);
        this.agent = this.channel.newAgent();
        this.agent.addListener((agent, message) -> {
            if (!this.instanceData.getId().equalsIgnoreCase(((RequestMessage)message).targetServer)) {
                return ConversationReply.noReply();
            }
            Promise<RedirectSystem.Response> response = this.handler.handle((RedirectSystem.Request)((Object)message));
            response.thenAcceptAsync(r -> {
                if (!r.isAllowed()) {
                    return;
                }
                this.expectedPlayers.put(((RequestMessage)message).uuid, (RedirectSystem.Response)r);
                this.redirector.redirectPlayer(this.instanceData.getId(), Profile.create(((RequestMessage)message).uuid, ((RequestMessage)message).username));
            });
            return ConversationReply.ofPromise(response.thenApplyAsync(r -> {
                ResponseMessage resp = new ResponseMessage();
                resp.convoId = ((RequestMessage)message).convoId;
                resp.allowed = r.isAllowed();
                resp.reason = r.getReason();
                resp.params = new HashMap<String, String>(r.getParams());
                return resp;
            }));
        });
        this.loginEventListener = Events.subscribe(AsyncPlayerPreLoginEvent.class).filter(e -> this.ensureJoinedViaQueue).handler(e -> {
            RedirectSystem.Response response = this.expectedPlayers.remove(e.getUniqueId());
            if (response == null || !response.isAllowed()) {
                e.disallow(AsyncPlayerPreLoginEvent.Result.KICK_WHITELIST, Text.colorize("&cSorry! The server is unable to process your login at this time. (queue error)"));
            }
        });
    }

    @Override
    public Promise<RedirectSystem.ReceivedResponse> redirectPlayer(@Nonnull String serverId, @Nonnull Profile profile, @Nonnull Map<String, String> params) {
        RequestMessage req = new RequestMessage();
        req.convoId = UUID.randomUUID();
        req.targetServer = serverId;
        req.uuid = profile.getUniqueId();
        req.username = profile.getName().orElse(null);
        req.params = new HashMap<String, String>(params);
        for (RedirectParameterProvider defaultProvider : this.defaultParameters) {
            for (Map.Entry<String, String> ent : defaultProvider.provide(profile, serverId).entrySet()) {
                req.params.putIfAbsent(ent.getKey(), ent.getValue());
            }
        }
        final Promise<RedirectSystem.ReceivedResponse> promise = Promise.empty();
        this.channel.sendMessage(req, new ConversationReplyListener<ResponseMessage>(){

            @Override
            @Nonnull
            public ConversationReplyListener.RegistrationAction onReply(@Nonnull ResponseMessage reply) {
                promise.supply(reply);
                return ConversationReplyListener.RegistrationAction.STOP_LISTENING;
            }

            @Override
            public void onTimeout(@Nonnull List<ResponseMessage> replies) {
                promise.supply(MissingResponse.INSTANCE);
            }
        }, 5L, TimeUnit.SECONDS);
        return promise;
    }

    @Override
    public void setHandler(@Nonnull RedirectSystem.RequestHandler handler) {
        this.handler = Objects.requireNonNull(handler, "handler");
    }

    @Override
    public void addDefaultParameterProvider(@Nonnull RedirectParameterProvider provider) {
        this.defaultParameters.add(provider);
    }

    @Override
    public void setEnsure(boolean ensureJoinedViaQueue) {
        this.ensureJoinedViaQueue = ensureJoinedViaQueue;
    }

    @Override
    public int getExpectedConnectionsCount() {
        return this.expectedPlayers.size();
    }

    @Override
    public void close() {
        this.agent.close();
        this.loginEventListener.close();
    }

    private static final class AllowAllHandler
    implements RedirectSystem.RequestHandler {
        private AllowAllHandler() {
        }

        @Override
        @Nonnull
        public Promise<RedirectSystem.Response> handle(@Nonnull RedirectSystem.Request request) {
            return Promise.completed(RedirectSystem.Response.allow());
        }
    }

    private static final class MissingResponse
    implements RedirectSystem.ReceivedResponse {
        private static final MissingResponse INSTANCE = new MissingResponse();

        private MissingResponse() {
        }

        @Override
        @Nonnull
        public RedirectSystem.ReceivedResponse.Status getStatus() {
            return RedirectSystem.ReceivedResponse.Status.NO_REPLY;
        }

        @Override
        @Nonnull
        public Optional<String> getReason() {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Map<String, String> getParams() {
            return ImmutableMap.of();
        }
    }

    private static final class ResponseMessage
    implements ConversationMessage,
    RedirectSystem.ReceivedResponse {
        private UUID convoId;
        private boolean allowed;
        private String reason;
        private Map<String, String> params;

        private ResponseMessage() {
        }

        @Override
        @Nonnull
        public UUID getConversationId() {
            return this.convoId;
        }

        @Override
        @Nonnull
        public RedirectSystem.ReceivedResponse.Status getStatus() {
            return this.allowed ? RedirectSystem.ReceivedResponse.Status.ALLOWED : RedirectSystem.ReceivedResponse.Status.DENIED;
        }

        @Override
        @Nonnull
        public Optional<String> getReason() {
            return Optional.ofNullable(this.reason);
        }

        @Override
        @Nonnull
        public Map<String, String> getParams() {
            return ImmutableMap.copyOf(this.params);
        }
    }

    private static final class RequestMessage
    implements ConversationMessage,
    RedirectSystem.Request {
        private UUID convoId;
        private String targetServer;
        private UUID uuid;
        private String username;
        private Map<String, String> params;

        private RequestMessage() {
        }

        @Override
        @Nonnull
        public UUID getConversationId() {
            return this.convoId;
        }

        @Override
        @Nonnull
        public Profile getProfile() {
            return Profile.create(this.uuid, this.username);
        }

        @Override
        @Nonnull
        public Map<String, String> getParams() {
            return ImmutableMap.copyOf(this.params);
        }
    }
}

