/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.metadata;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.lucko.helper.metadata.MetadataMap;
import me.lucko.helper.metadata.MetadataRegistry;

public class AbstractMetadataRegistry<T>
implements MetadataRegistry<T> {
    private static final CacheLoader<?, MetadataMap> LOADER = new Loader();
    @Nonnull
    protected final LoadingCache<T, MetadataMap> cache = CacheBuilder.newBuilder().build(AbstractMetadataRegistry.getLoader());

    private static <T> CacheLoader<T, MetadataMap> getLoader() {
        return LOADER;
    }

    @Override
    @Nonnull
    public MetadataMap provide(@Nonnull T id) {
        Objects.requireNonNull(id, "id");
        return (MetadataMap)this.cache.getUnchecked(id);
    }

    @Override
    @Nonnull
    public Optional<MetadataMap> get(@Nonnull T id) {
        Objects.requireNonNull(id, "id");
        return Optional.ofNullable(this.cache.getIfPresent(id));
    }

    @Override
    public void remove(@Nonnull T id) {
        MetadataMap map = (MetadataMap)this.cache.asMap().remove(id);
        if (map != null) {
            map.clear();
        }
    }

    @Override
    public void cleanup() {
        this.cache.asMap().values().removeIf(MetadataMap::isEmpty);
    }

    private static final class Loader<T>
    extends CacheLoader<T, MetadataMap> {
        private Loader() {
        }

        public MetadataMap load(@Nonnull T key) {
            return MetadataMap.create();
        }
    }
}

