/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.messaging.reqresp;

import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import me.lucko.helper.messaging.Messenger;
import me.lucko.helper.messaging.conversation.ConversationChannel;
import me.lucko.helper.messaging.conversation.ConversationReply;
import me.lucko.helper.messaging.conversation.ConversationReplyListener;
import me.lucko.helper.messaging.reqresp.ReqResMessage;
import me.lucko.helper.messaging.reqresp.ReqRespChannel;
import me.lucko.helper.promise.Promise;

public class SimpleReqRespChannel<Req, Resp>
implements ReqRespChannel<Req, Resp> {
    private final ConversationChannel<ReqResMessage<Req>, ReqResMessage<Resp>> channel;

    public SimpleReqRespChannel(Messenger messenger, String name, TypeToken<Req> reqType, TypeToken<Resp> respType) {
        TypeToken reqMsgType = new TypeToken<ReqResMessage<Req>>(){}.where(new TypeParameter<Req>(){}, reqType);
        TypeToken respMsgType = new TypeToken<ReqResMessage<Resp>>(){}.where(new TypeParameter<Resp>(){}, respType);
        this.channel = messenger.getConversationChannel(name, reqMsgType, respMsgType);
    }

    @Override
    public Promise<Resp> request(Req req) {
        ReqResMessage<Req> msg = new ReqResMessage<Req>(UUID.randomUUID(), req);
        final Promise promise = Promise.empty();
        this.channel.sendMessage(msg, new ConversationReplyListener<ReqResMessage<Resp>>(){

            @Override
            @Nonnull
            public ConversationReplyListener.RegistrationAction onReply(@Nonnull ReqResMessage<Resp> reply) {
                promise.supply(reply.getBody());
                return ConversationReplyListener.RegistrationAction.STOP_LISTENING;
            }

            @Override
            public void onTimeout(@Nonnull List<ReqResMessage<Resp>> replies) {
                promise.supplyException(new TimeoutException("Request timed out"));
            }
        }, 5L, TimeUnit.SECONDS);
        return promise;
    }

    @Override
    public void responseHandler(ReqRespChannel.ResponseHandler<Req, Resp> handler) {
        this.channel.newAgent((agent, message) -> {
            UUID id = message.getConversationId();
            Object req = message.getBody();
            Object resp = handler.response(req);
            if (resp != null) {
                return ConversationReply.of(new ReqResMessage(id, resp));
            }
            return ConversationReply.noReply();
        });
    }

    @Override
    public void asyncResponseHandler(ReqRespChannel.AsyncResponseHandler<Req, Resp> handler) {
        this.channel.newAgent((agent, message) -> {
            UUID id = message.getConversationId();
            Object req = message.getBody();
            Promise promise = handler.response(req);
            if (promise != null) {
                Promise<ReqResMessage> composedPromise = promise.thenApplyAsync(resp -> resp == null ? null : new ReqResMessage<Object>(id, resp));
                return ConversationReply.ofPromise(composedPromise);
            }
            return ConversationReply.noReply();
        });
    }

    @Override
    public void close() {
        this.channel.close();
    }
}

