/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.messaging;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.Schedulers;
import me.lucko.helper.messaging.Channel;
import me.lucko.helper.messaging.ChannelAgent;
import me.lucko.helper.messaging.ChannelListener;
import me.lucko.helper.messaging.Messenger;
import me.lucko.helper.messaging.codec.Codec;
import me.lucko.helper.messaging.codec.GZipCodec;
import me.lucko.helper.messaging.codec.GsonCodec;
import me.lucko.helper.messaging.codec.Message;
import me.lucko.helper.promise.Promise;
import me.lucko.helper.utils.annotation.NonnullByDefault;

@NonnullByDefault
public class AbstractMessenger
implements Messenger {
    private final LoadingCache<Map.Entry<String, TypeToken<?>>, AbstractChannel<?>> channels = CacheBuilder.newBuilder().build(new ChannelLoader());
    private final BiConsumer<String, byte[]> outgoingMessages;
    private final Consumer<String> notifySub;
    private final Consumer<String> notifyUnsub;

    public AbstractMessenger(BiConsumer<String, byte[]> outgoingMessages, Consumer<String> notifySub, Consumer<String> notifyUnsub) {
        this.outgoingMessages = Objects.requireNonNull(outgoingMessages, "outgoingMessages");
        this.notifySub = Objects.requireNonNull(notifySub, "notifySub");
        this.notifyUnsub = Objects.requireNonNull(notifyUnsub, "notifyUnsub");
    }

    public void registerIncomingMessage(String channel, byte[] message) {
        Objects.requireNonNull(channel, "channel");
        Objects.requireNonNull(message, "message");
        for (Map.Entry c : this.channels.asMap().entrySet()) {
            if (!((String)((Map.Entry)c.getKey()).getKey()).equals(channel)) continue;
            ((AbstractChannel)c.getValue()).onIncomingMessage(message);
        }
    }

    @Override
    @Nonnull
    public <T> Channel<T> getChannel(@Nonnull String name, @Nonnull TypeToken<T> type) {
        Objects.requireNonNull(name, "name");
        Preconditions.checkArgument((!name.trim().isEmpty() ? 1 : 0) != 0, (Object)"name cannot be empty");
        Objects.requireNonNull(type, "type");
        return (Channel)this.channels.getUnchecked((Object)Maps.immutableEntry((Object)name, type));
    }

    private static <T> Codec<T> getCodec(TypeToken<T> type) {
        Class rawType = type.getRawType();
        do {
            Message message;
            if ((message = rawType.getAnnotation(Message.class)) == null) continue;
            Class<Codec<?>> codec = message.codec();
            try {
                return codec.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        } while ((rawType = rawType.getSuperclass()) != null);
        return new GsonCodec<T>(type);
    }

    private class ChannelLoader<T>
    extends CacheLoader<Map.Entry<String, TypeToken<T>>, Channel<T>> {
        private ChannelLoader() {
        }

        public Channel<T> load(Map.Entry<String, TypeToken<T>> spec) throws Exception {
            return new AbstractChannel(AbstractMessenger.this, spec.getKey(), spec.getValue());
        }
    }

    private static class AbstractChannelAgent<T>
    implements ChannelAgent<T> {
        @Nullable
        private AbstractChannel<T> channel;
        private final Set<ChannelListener<T>> listeners = ConcurrentHashMap.newKeySet();

        AbstractChannelAgent(AbstractChannel<T> channel) {
            this.channel = channel;
        }

        private void onIncomingMessage(T message) {
            for (ChannelListener<T> listener : this.listeners) {
                Schedulers.async().run(() -> {
                    try {
                        listener.onMessage(this, message);
                    }
                    catch (Exception e) {
                        new RuntimeException("Unable to pass decoded message to listener: " + listener, e).printStackTrace();
                    }
                });
            }
        }

        @Override
        public Channel<T> getChannel() {
            Preconditions.checkState((this.channel != null ? 1 : 0) != 0, (Object)"agent not active");
            return this.channel;
        }

        @Override
        public Set<ChannelListener<T>> getListeners() {
            Preconditions.checkState((this.channel != null ? 1 : 0) != 0, (Object)"agent not active");
            return ImmutableSet.copyOf(this.listeners);
        }

        @Override
        public boolean hasListeners() {
            return !this.listeners.isEmpty();
        }

        @Override
        public boolean addListener(ChannelListener<T> listener) {
            Preconditions.checkState((this.channel != null ? 1 : 0) != 0, (Object)"agent not active");
            try {
                boolean bl = this.listeners.add(listener);
                return bl;
            }
            finally {
                ((AbstractChannel)this.channel).checkSubscription();
            }
        }

        @Override
        public boolean removeListener(ChannelListener<T> listener) {
            Preconditions.checkState((this.channel != null ? 1 : 0) != 0, (Object)"agent not active");
            try {
                boolean bl = this.listeners.remove(listener);
                return bl;
            }
            finally {
                ((AbstractChannel)this.channel).checkSubscription();
            }
        }

        @Override
        public void close() {
            if (this.channel == null) {
                return;
            }
            this.listeners.clear();
            ((AbstractChannel)this.channel).agents.remove(this);
            ((AbstractChannel)this.channel).checkSubscription();
            this.channel = null;
        }
    }

    private static class AbstractChannel<T>
    implements Channel<T> {
        private final AbstractMessenger messenger;
        private final String name;
        private final TypeToken<T> type;
        private final Codec<T> codec;
        private final Set<AbstractChannelAgent<T>> agents = ConcurrentHashMap.newKeySet();
        private boolean subscribed = false;

        private AbstractChannel(AbstractMessenger messenger, String name, TypeToken<T> type) {
            this.messenger = messenger;
            this.name = name;
            this.type = type;
            this.codec = new GZipCodec<T>(AbstractMessenger.getCodec(type));
        }

        private void onIncomingMessage(byte[] message) {
            try {
                T decoded = this.codec.decode(message);
                Objects.requireNonNull(decoded, "decoded");
                for (AbstractChannelAgent<T> agent : this.agents) {
                    try {
                        ((AbstractChannelAgent)agent).onIncomingMessage(decoded);
                    }
                    catch (Exception e) {
                        new RuntimeException("Unable to pass decoded message to agent: " + decoded, e).printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                new RuntimeException("Unable to decode message: " + Base64.getEncoder().encodeToString(message), e).printStackTrace();
            }
        }

        private void checkSubscription() {
            boolean shouldSubscribe = this.agents.stream().anyMatch(AbstractChannelAgent::hasListeners);
            if (shouldSubscribe == this.subscribed) {
                return;
            }
            this.subscribed = shouldSubscribe;
            Schedulers.async().run(() -> {
                try {
                    if (shouldSubscribe) {
                        this.messenger.notifySub.accept(this.name);
                    } else {
                        this.messenger.notifyUnsub.accept(this.name);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TypeToken<T> getType() {
            return this.type;
        }

        @Override
        @Nonnull
        public Codec<T> getCodec() {
            return this.codec;
        }

        @Override
        public ChannelAgent<T> newAgent() {
            AbstractChannelAgent agent = new AbstractChannelAgent(this);
            this.agents.add(agent);
            return agent;
        }

        @Override
        public Promise<Void> sendMessage(T message) {
            Objects.requireNonNull(message, "message");
            return Schedulers.async().call(() -> {
                byte[] buf = this.codec.encode(message);
                this.messenger.outgoingMessages.accept(this.name, buf);
                return null;
            });
        }
    }
}

