/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.event.functional.protocol;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.lucko.helper.event.ProtocolSubscription;
import me.lucko.helper.event.functional.protocol.ProtocolSubscriptionBuilderImpl;
import me.lucko.helper.internal.LoaderUtils;
import me.lucko.helper.protocol.Protocol;
import org.bukkit.plugin.Plugin;

class HelperProtocolListener
extends PacketAdapter
implements ProtocolSubscription {
    private final Set<PacketType> types;
    private final BiConsumer<? super PacketEvent, Throwable> exceptionConsumer;
    private final Predicate<PacketEvent>[] filters;
    private final BiPredicate<ProtocolSubscription, PacketEvent>[] preExpiryTests;
    private final BiPredicate<ProtocolSubscription, PacketEvent>[] midExpiryTests;
    private final BiPredicate<ProtocolSubscription, PacketEvent>[] postExpiryTests;
    private final BiConsumer<ProtocolSubscription, ? super PacketEvent>[] handlers;
    private final AtomicLong callCount = new AtomicLong(0L);
    private final AtomicBoolean active = new AtomicBoolean(true);

    HelperProtocolListener(ProtocolSubscriptionBuilderImpl builder, List<BiConsumer<ProtocolSubscription, ? super PacketEvent>> handlers) {
        super((Plugin)LoaderUtils.getPlugin(), builder.priority, builder.types);
        this.types = builder.types;
        this.exceptionConsumer = builder.exceptionConsumer;
        this.filters = builder.filters.toArray(new Predicate[builder.filters.size()]);
        this.preExpiryTests = builder.preExpiryTests.toArray(new BiPredicate[builder.preExpiryTests.size()]);
        this.midExpiryTests = builder.midExpiryTests.toArray(new BiPredicate[builder.midExpiryTests.size()]);
        this.postExpiryTests = builder.postExpiryTests.toArray(new BiPredicate[builder.postExpiryTests.size()]);
        this.handlers = handlers.toArray(new BiConsumer[handlers.size()]);
        Protocol.manager().addPacketListener((PacketListener)this);
    }

    public void onPacketReceiving(PacketEvent event) {
        this.onPacket(event);
    }

    public void onPacketSending(PacketEvent event) {
        this.onPacket(event);
    }

    private void onPacket(PacketEvent event) {
        if (!this.types.contains(event.getPacketType())) {
            return;
        }
        if (!this.active.get()) {
            return;
        }
        for (BiPredicate<ProtocolSubscription, PacketEvent> biPredicate : this.preExpiryTests) {
            if (!biPredicate.test(this, event)) continue;
            this.unregister();
            return;
        }
        try {
            for (Predicate<PacketEvent> predicate : this.filters) {
                if (predicate.test(event)) continue;
                return;
            }
            for (BiPredicate<ProtocolSubscription, PacketEvent> biPredicate : this.midExpiryTests) {
                if (!biPredicate.test(this, event)) continue;
                this.unregister();
                return;
            }
            for (BiConsumer<ProtocolSubscription, ? super PacketEvent> biConsumer : this.handlers) {
                biConsumer.accept(this, event);
            }
            this.callCount.incrementAndGet();
        }
        catch (Throwable t) {
            this.exceptionConsumer.accept((PacketEvent)event, t);
        }
        for (BiPredicate<ProtocolSubscription, PacketEvent> biPredicate : this.postExpiryTests) {
            if (!biPredicate.test(this, event)) continue;
            this.unregister();
            return;
        }
    }

    @Override
    @Nonnull
    public Set<PacketType> getPackets() {
        return this.types;
    }

    @Override
    public boolean isActive() {
        return this.active.get();
    }

    @Override
    public boolean isClosed() {
        return !this.active.get();
    }

    @Override
    public long getCallCounter() {
        return this.callCount.get();
    }

    @Override
    public boolean unregister() {
        if (!this.active.getAndSet(false)) {
            return false;
        }
        Protocol.manager().removePacketListener((PacketListener)this);
        return true;
    }

    @Override
    public Collection<Object> getFunctions() {
        ArrayList<Object> functions = new ArrayList<Object>();
        Collections.addAll(functions, this.filters);
        Collections.addAll(functions, this.preExpiryTests);
        Collections.addAll(functions, this.midExpiryTests);
        Collections.addAll(functions, this.postExpiryTests);
        Collections.addAll(functions, this.handlers);
        return functions;
    }
}

