/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.objectmapping.serialize;

import com.google.common.reflect.TypeToken;
import java.util.UUID;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.objectmapping.ObjectMappingException;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class UUIDSerializer
implements TypeSerializer<UUID> {
    UUIDSerializer() {
    }

    @Override
    public UUID deserialize(@NonNull TypeToken<?> type, @NonNull ConfigurationNode value) throws ObjectMappingException {
        try {
            return UUID.fromString(value.getString());
        }
        catch (IllegalArgumentException ex) {
            throw new ObjectMappingException("Value not a UUID", ex);
        }
    }

    @Override
    public void serialize(@NonNull TypeToken<?> type, @Nullable UUID obj, @NonNull ConfigurationNode value) throws ObjectMappingException {
        value.setValue(obj.toString());
    }
}

