/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.bucket;

import com.google.common.collect.ImmutableList;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import me.lucko.helper.bucket.Bucket;
import me.lucko.helper.bucket.BucketPartition;
import me.lucko.helper.bucket.Cycle;
import me.lucko.helper.bucket.partitioning.PartitioningStrategy;

public abstract class AbstractBucket<E>
extends AbstractSet<E>
implements Bucket<E> {
    protected final PartitioningStrategy<E> strategy;
    protected final int size;
    protected final Set<E> content;
    protected final ImmutableList<Set<E>> partitions;
    protected final ImmutableList<BucketPartition<E>> partitionView;
    private final Cycle<BucketPartition<E>> partitionCycle;

    protected AbstractBucket(int size, PartitioningStrategy<E> strategy) {
        this.strategy = strategy;
        this.size = size;
        this.content = this.createSet();
        ImmutableList.Builder sets = ImmutableList.builder();
        ImmutableList.Builder views = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            Set<E> set = this.createSet();
            sets.add(set);
            SetView view = new SetView(set, i);
            views.add((Object)view);
        }
        this.partitions = sets.build();
        this.partitionView = views.build();
        this.partitionCycle = Cycle.of(this.partitionView);
    }

    protected abstract Set<E> createSet();

    @Override
    public int getPartitionCount() {
        return this.size;
    }

    @Override
    @Nonnull
    public BucketPartition<E> getPartition(int index) {
        return (BucketPartition)this.partitionView.get(index);
    }

    @Override
    @Nonnull
    public List<BucketPartition<E>> getPartitions() {
        return this.partitionView;
    }

    @Override
    @Nonnull
    public Cycle<BucketPartition<E>> asCycle() {
        return this.partitionCycle;
    }

    @Override
    public boolean add(E e) {
        if (e == null) {
            throw new NullPointerException("Buckets do not accept null elements.");
        }
        if (!this.content.add(e)) {
            return false;
        }
        ((Set)this.partitions.get(this.strategy.allocate(e, this))).add(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (!this.content.remove(o)) {
            return false;
        }
        for (Set partition : this.partitions) {
            partition.remove(o);
        }
        return true;
    }

    @Override
    public void clear() {
        for (Set partition : this.partitions) {
            partition.clear();
        }
        this.content.clear();
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        return new BucketIterator();
    }

    @Override
    public int size() {
        return this.content.size();
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.content.contains(o);
    }

    private final class SetViewIterator
    implements Iterator<E> {
        private final Iterator<E> delegate;
        private E current;

        private SetViewIterator(Iterator<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public E next() {
            this.current = this.delegate.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.delegate.remove();
            AbstractBucket.this.content.remove(this.current);
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            this.delegate.forEachRemaining(action);
        }
    }

    private final class SetView
    extends AbstractSet<E>
    implements BucketPartition<E> {
        private final Set<E> backing;
        private final int index;

        private SetView(Set<E> backing, int index) {
            this.backing = backing;
            this.index = index;
        }

        @Override
        public int getPartitionIndex() {
            return this.index;
        }

        @Override
        public Iterator<E> iterator() {
            return new SetViewIterator(this.backing.iterator());
        }

        @Override
        public boolean remove(Object o) {
            if (!this.backing.remove(o)) {
                return false;
            }
            AbstractBucket.this.content.remove(o);
            return true;
        }

        @Override
        public void clear() {
            AbstractBucket.this.content.removeAll(this.backing);
            this.backing.clear();
        }

        @Override
        public int size() {
            return this.backing.size();
        }

        @Override
        public boolean isEmpty() {
            return this.backing.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.backing.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.backing.toArray();
        }

        @Override
        public <T> T[] toArray(@Nonnull T[] a) {
            return this.backing.toArray(a);
        }

        @Override
        public boolean containsAll(@Nonnull Collection<?> c) {
            return this.backing.containsAll(c);
        }

        @Override
        public int hashCode() {
            return this.backing.hashCode();
        }
    }

    private final class BucketIterator
    implements Iterator<E> {
        private final Iterator<E> delegate;
        private E current;

        private BucketIterator() {
            this.delegate = AbstractBucket.this.content.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public E next() {
            this.current = this.delegate.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.delegate.remove();
            for (Set partition : AbstractBucket.this.partitions) {
                partition.remove(this.current);
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            this.delegate.forEachRemaining(action);
        }
    }
}

