/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.shadow;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;
import me.lucko.shadow.Reflection;
import me.lucko.shadow.Shadow;
import me.lucko.shadow.TargetResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface DynamicClassTarget {
    public static final TargetResolver RESOLVER = new TargetResolver(){

        @Override
        public @NonNull Optional<Class<?>> lookupClass(@NonNull Class<? extends Shadow> shadowClass) throws ClassNotFoundException {
            DynamicClassTarget annotation = shadowClass.getAnnotation(DynamicClassTarget.class);
            if (annotation == null) {
                return Optional.empty();
            }
            return Optional.of(Reflection.getInstance(Function.class, annotation.value()).computeClass(shadowClass));
        }
    };

    public @NonNull Class<? extends Function> value();

    @FunctionalInterface
    public static interface Function {
        public @NonNull Class<?> computeClass(@NonNull Class<? extends Shadow> var1) throws ClassNotFoundException;
    }
}

