/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.scoreboard;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.AbstractStructure;
import com.comphenix.protocol.events.InternalStructure;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import me.lucko.helper.protocol.Protocol;
import me.lucko.helper.reflect.MinecraftVersion;
import me.lucko.helper.reflect.MinecraftVersions;
import me.lucko.helper.scoreboard.PacketScoreboard;
import me.lucko.helper.scoreboard.ScoreboardTeam;
import me.lucko.helper.text.Text;
import me.lucko.helper.utils.annotation.NonnullByDefault;
import me.lucko.shadow.bukkit.PackageVersion;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

@NonnullByDefault
public class PacketScoreboardTeam
implements ScoreboardTeam {
    private static final boolean SUPPORTS_COLLISION_RULE = MinecraftVersion.getRuntimeVersion().isAfterOrEq(MinecraftVersions.v1_9);
    private static final boolean GTEQ_1_13 = MinecraftVersion.getRuntimeVersion().isAfterOrEq(MinecraftVersions.v1_13);
    private static final boolean GTEQ_1_17 = PackageVersion.runtimeVersion().isAfterOrEq(PackageVersion.v1_17_R1);
    private static final int MAX_NAME_LENGTH = 32;
    private static final int MAX_PREFIX_SUFFIX_LENGTH = 16;
    private static final int MAX_TEAM_MEMBER_LENGTH = 40;
    private final String id;
    private boolean autoSubscribe;
    private final Set<String> players = Collections.synchronizedSet(new HashSet());
    private final Set<Player> subscribed = Collections.synchronizedSet(new HashSet());
    private String displayName;
    private String prefix = "";
    private String suffix = "";
    private boolean allowFriendlyFire = true;
    private boolean canSeeFriendlyInvisibles = true;
    private ScoreboardTeam.NameTagVisibility nameTagVisibility = ScoreboardTeam.NameTagVisibility.ALWAYS;
    private ScoreboardTeam.CollisionRule collisionRule = ScoreboardTeam.CollisionRule.ALWAYS;
    private ChatColor color = ChatColor.RESET;
    private static final Map<ChatColor, Integer> COLOR_CODES;

    private static String trimName(String name) {
        return name.length() > 32 ? name.substring(0, 32) : name;
    }

    private static String trimPrefixSuffix(String name) {
        return name.length() > 16 ? name.substring(0, 16) : name;
    }

    private static String trimMember(String name) {
        return name.length() > 40 ? name.substring(0, 40) : name;
    }

    public PacketScoreboardTeam(String id, String displayName, boolean autoSubscribe) {
        Objects.requireNonNull(id, "id");
        Preconditions.checkArgument((id.length() <= 16 ? 1 : 0) != 0, (Object)"id cannot be longer than 16 characters");
        this.id = id;
        this.displayName = PacketScoreboardTeam.trimName(Text.colorize(Objects.requireNonNull(displayName, "displayName")));
        this.autoSubscribe = autoSubscribe;
    }

    public PacketScoreboardTeam(String id, String displayName) {
        this(id, displayName, true);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean shouldAutoSubscribe() {
        return this.autoSubscribe;
    }

    @Override
    public void setAutoSubscribe(boolean autoSubscribe) {
        this.autoSubscribe = autoSubscribe;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        Objects.requireNonNull(displayName, "displayName");
        displayName = PacketScoreboardTeam.trimName(Text.colorize(displayName));
        if (this.displayName.equals(displayName)) {
            return;
        }
        this.displayName = displayName;
        Protocol.broadcastPacket(this.subscribed, this.newUpdatePacket());
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        Objects.requireNonNull(prefix, "prefix");
        prefix = PacketScoreboardTeam.trimPrefixSuffix(Text.colorize(prefix));
        if (this.prefix.equals(prefix)) {
            return;
        }
        this.prefix = prefix;
        Protocol.broadcastPacket(this.subscribed, this.newUpdatePacket());
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public void setSuffix(String suffix) {
        Objects.requireNonNull(suffix, "suffix");
        suffix = PacketScoreboardTeam.trimPrefixSuffix(Text.colorize(suffix));
        if (this.suffix.equals(suffix)) {
            return;
        }
        this.suffix = suffix;
        Protocol.broadcastPacket(this.subscribed, this.newUpdatePacket());
    }

    @Override
    public boolean isAllowFriendlyFire() {
        return this.allowFriendlyFire;
    }

    @Override
    public void setAllowFriendlyFire(boolean allowFriendlyFire) {
        if (this.allowFriendlyFire == allowFriendlyFire) {
            return;
        }
        this.allowFriendlyFire = allowFriendlyFire;
        Protocol.broadcastPacket(this.subscribed, this.newUpdatePacket());
    }

    @Override
    public boolean isCanSeeFriendlyInvisibles() {
        return this.canSeeFriendlyInvisibles;
    }

    @Override
    public void setCanSeeFriendlyInvisibles(boolean canSeeFriendlyInvisibles) {
        if (this.canSeeFriendlyInvisibles == canSeeFriendlyInvisibles) {
            return;
        }
        this.canSeeFriendlyInvisibles = canSeeFriendlyInvisibles;
        Protocol.broadcastPacket(this.subscribed, this.newUpdatePacket());
    }

    @Override
    public ScoreboardTeam.NameTagVisibility getNameTagVisibility() {
        return this.nameTagVisibility;
    }

    @Override
    public void setNameTagVisibility(ScoreboardTeam.NameTagVisibility nameTagVisibility) {
        Objects.requireNonNull(nameTagVisibility, "nameTagVisibility");
        if (this.nameTagVisibility == nameTagVisibility) {
            return;
        }
        this.nameTagVisibility = nameTagVisibility;
        Protocol.broadcastPacket(this.subscribed, this.newUpdatePacket());
    }

    @Override
    public ScoreboardTeam.CollisionRule getCollisionRule() {
        return this.collisionRule;
    }

    @Override
    public void setCollisionRule(ScoreboardTeam.CollisionRule collisionRule) {
        Objects.requireNonNull(collisionRule, "collisionRule");
        if (this.collisionRule == collisionRule) {
            return;
        }
        this.collisionRule = collisionRule;
        Protocol.broadcastPacket(this.subscribed, this.newUpdatePacket());
    }

    @Override
    public ChatColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(ChatColor color) {
        Objects.requireNonNull(color, "color");
        if (this.color == color) {
            return;
        }
        this.color = color;
        Protocol.broadcastPacket(this.subscribed, this.newUpdatePacket());
    }

    @Override
    public boolean addPlayer(String player) {
        Objects.requireNonNull(player, "player");
        player = PacketScoreboardTeam.trimMember(player);
        if (!this.players.add(player)) {
            return false;
        }
        Protocol.broadcastPacket(this.subscribed, this.newTeamMemberUpdatePacket(player, MemberAction.ADD));
        return true;
    }

    @Override
    public boolean removePlayer(String player) {
        Objects.requireNonNull(player, "player");
        player = PacketScoreboardTeam.trimMember(player);
        if (!this.players.remove(player)) {
            return false;
        }
        Protocol.broadcastPacket(this.subscribed, this.newTeamMemberUpdatePacket(player, MemberAction.REMOVE));
        return true;
    }

    @Override
    public boolean hasPlayer(String player) {
        Objects.requireNonNull(player, "player");
        return this.players.contains(PacketScoreboardTeam.trimMember(player));
    }

    @Override
    public Set<String> getPlayers() {
        return ImmutableSet.copyOf(this.players);
    }

    @Override
    public void subscribe(Player player) {
        Protocol.sendPacket(player, this.newCreatePacket());
        this.subscribed.add(player);
    }

    @Override
    public void unsubscribe(Player player) {
        this.unsubscribe(player, false);
    }

    @Override
    public void unsubscribe(Player player, boolean fast) {
        if (!this.subscribed.remove(player) || fast) {
            return;
        }
        Protocol.sendPacket(player, this.newRemovePacket());
    }

    @Override
    public void unsubscribeAll() {
        Protocol.broadcastPacket(this.subscribed, this.newRemovePacket());
        this.subscribed.clear();
    }

    private PacketContainer newCreatePacket() {
        PacketContainer packet = this.newUpdatePacket();
        packet.getIntegers().write(GTEQ_1_13 ? 0 : 1, (Object)UpdateType.CREATE.getCode());
        ArrayList<String> players = new ArrayList<String>(this.getPlayers());
        packet.getSpecificModifier(Collection.class).write(0, players);
        return packet;
    }

    private PacketContainer newRemovePacket() {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SCOREBOARD_TEAM);
        packet.getStrings().write(0, (Object)this.getId());
        packet.getIntegers().write(GTEQ_1_13 ? 0 : 1, (Object)UpdateType.REMOVE.getCode());
        return packet;
    }

    private PacketContainer newUpdatePacket() {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SCOREBOARD_TEAM);
        packet.getStrings().write(0, (Object)this.getId());
        packet.getIntegers().write(GTEQ_1_13 ? 0 : 1, (Object)UpdateType.UPDATE.getCode());
        Object struct = GTEQ_1_17 ? (AbstractStructure)((Optional)packet.getOptionalStructures().readSafely(0)).get() : packet;
        if (GTEQ_1_13) {
            struct.getChatComponents().write(0, (Object)PacketScoreboard.toComponent(this.getDisplayName()));
            struct.getChatComponents().write(1, (Object)PacketScoreboard.toComponent(this.getPrefix()));
            struct.getChatComponents().write(2, (Object)PacketScoreboard.toComponent(this.getSuffix()));
        } else {
            struct.getStrings().write(1, (Object)this.getDisplayName());
            struct.getStrings().write(2, (Object)this.getPrefix());
            struct.getStrings().write(3, (Object)this.getSuffix());
        }
        int flags = 0;
        if (this.isAllowFriendlyFire()) {
            flags |= 1;
        }
        if (this.isCanSeeFriendlyInvisibles()) {
            flags |= 2;
        }
        struct.getIntegers().write(GTEQ_1_17 ? 0 : (GTEQ_1_13 ? 1 : 2), (Object)flags);
        struct.getStrings().write(GTEQ_1_17 ? 0 : (GTEQ_1_13 ? 1 : 4), (Object)this.getNameTagVisibility().getProtocolName());
        if (SUPPORTS_COLLISION_RULE) {
            struct.getStrings().write(GTEQ_1_17 ? 1 : (GTEQ_1_13 ? 2 : 5), (Object)this.getCollisionRule().getProtocolName());
        }
        if (GTEQ_1_13) {
            struct.getEnumModifier(ChatColor.class, MinecraftReflection.getMinecraftClass((String)"EnumChatFormat")).write(0, (Object)this.getColor());
        } else {
            struct.getIntegers().write(0, (Object)COLOR_CODES.getOrDefault(this.getColor(), -1));
        }
        if (GTEQ_1_17) {
            packet.getOptionalStructures().write(0, Optional.of((InternalStructure)struct));
        }
        return packet;
    }

    private PacketContainer newTeamMemberUpdatePacket(String player, MemberAction action) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SCOREBOARD_TEAM);
        packet.getStrings().write(0, (Object)this.getId());
        switch (action) {
            case ADD: {
                packet.getIntegers().write(GTEQ_1_13 ? 0 : 1, (Object)UpdateType.ADD_PLAYERS.getCode());
                break;
            }
            case REMOVE: {
                packet.getIntegers().write(GTEQ_1_13 ? 0 : 1, (Object)UpdateType.REMOVE_PLAYERS.getCode());
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        packet.getSpecificModifier(Collection.class).write(0, Collections.singletonList(player));
        return packet;
    }

    static {
        EnumMap<ChatColor, Integer> codes = new EnumMap<ChatColor, Integer>(ChatColor.class);
        try {
            Field codeField = ChatColor.class.getDeclaredField("intCode");
            codeField.setAccessible(true);
            for (ChatColor color : ChatColor.values()) {
                if (!color.isColor()) continue;
                codes.put(color, codeField.getInt(color));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        COLOR_CODES = codes;
    }

    private static enum UpdateType {
        CREATE(0),
        REMOVE(1),
        UPDATE(2),
        ADD_PLAYERS(3),
        REMOVE_PLAYERS(4);

        private final int code;

        private UpdateType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    private static enum MemberAction {
        ADD,
        REMOVE;

    }
}

