/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.network.redirect;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.Services;
import me.lucko.helper.messaging.InstanceData;
import me.lucko.helper.messaging.Messenger;
import me.lucko.helper.network.redirect.AbstractRedirectSystem;
import me.lucko.helper.network.redirect.PlayerRedirector;
import me.lucko.helper.network.redirect.RedirectParameterProvider;
import me.lucko.helper.profiles.Profile;
import me.lucko.helper.promise.Promise;
import me.lucko.helper.terminable.Terminable;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public interface RedirectSystem
extends Terminable {
    public static RedirectSystem create(Messenger messenger, InstanceData instanceData, PlayerRedirector redirecter) {
        return new AbstractRedirectSystem(messenger, instanceData, redirecter);
    }

    public static <M extends Messenger & InstanceData> RedirectSystem create(M messenger) {
        return new AbstractRedirectSystem(messenger, messenger, (PlayerRedirector)messenger);
    }

    public static RedirectSystem obtain(Supplier<RedirectSystem> ifElse) {
        RedirectSystem network = Services.get(RedirectSystem.class).orElse(null);
        if (network == null) {
            network = ifElse.get();
            Services.provide(RedirectSystem.class, network);
        }
        return network;
    }

    public Promise<ReceivedResponse> redirectPlayer(@Nonnull String var1, @Nonnull Profile var2, @Nonnull Map<String, String> var3);

    default public Promise<ReceivedResponse> redirectPlayer(@Nonnull String serverId, @Nonnull Player player, @Nonnull Map<String, String> params) {
        return this.redirectPlayer(serverId, Profile.create((HumanEntity)player), params);
    }

    public void setHandler(@Nonnull RequestHandler var1);

    public void addDefaultParameterProvider(@Nonnull RedirectParameterProvider var1);

    public void setEnsure(boolean var1);

    public int getExpectedConnectionsCount();

    @Override
    public void close();

    public static interface ReceivedResponse {
        @Nonnull
        public Status getStatus();

        @Nonnull
        public Optional<String> getReason();

        @Nonnull
        public Map<String, String> getParams();

        public static enum Status {
            ALLOWED,
            DENIED,
            NO_REPLY;

        }
    }

    public static interface RequestHandler {
        @Nonnull
        public Promise<Response> handle(@Nonnull Request var1);
    }

    public static final class Response {
        private static final Response ALLOW = new Response(true, null, (Map<String, String>)ImmutableMap.of());
        private static final Response DENY = new Response(false, null, (Map<String, String>)ImmutableMap.of());
        private final boolean allowed;
        private final String reason;
        private final Map<String, String> params;

        public static Response allow() {
            return ALLOW;
        }

        public static Response allow(@Nonnull Map<String, String> params) {
            return new Response(true, null, params);
        }

        public static Response deny() {
            return DENY;
        }

        public static Response deny(@Nonnull String reason) {
            return new Response(false, reason, (Map<String, String>)ImmutableMap.of());
        }

        public static Response deny(@Nonnull Map<String, String> params) {
            return new Response(false, null, params);
        }

        public static Response deny(@Nonnull String reason, @Nonnull Map<String, String> params) {
            return new Response(false, reason, params);
        }

        public Response(boolean allowed, @Nullable String reason, @Nonnull Map<String, String> params) {
            this.allowed = allowed;
            this.reason = reason;
            this.params = ImmutableMap.copyOf(params);
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        @Nullable
        public String getReason() {
            return this.reason;
        }

        public Map<String, String> getParams() {
            return this.params;
        }
    }

    public static interface Request {
        @Nonnull
        public Profile getProfile();

        @Nonnull
        public Map<String, String> getParams();
    }
}

