/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.metadata;

import com.google.common.reflect.TypeToken;
import java.util.Objects;
import me.lucko.helper.metadata.MetadataKey;
import me.lucko.helper.utils.annotation.NonnullByDefault;

@NonnullByDefault
final class MetadataKeyImpl<T>
implements MetadataKey<T> {
    private final String id;
    private final TypeToken<T> type;

    MetadataKeyImpl(String id, TypeToken<T> type) {
        this.id = id.toLowerCase();
        this.type = type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public TypeToken<T> getType() {
        return this.type;
    }

    @Override
    public T cast(Object object) throws ClassCastException {
        Objects.requireNonNull(object, "object");
        return this.type.getRawType().cast(object);
    }

    public boolean equals(Object obj) {
        return obj instanceof MetadataKeyImpl && ((MetadataKeyImpl)obj).getId().equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

