/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.internal;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import me.lucko.helper.Helper;
import me.lucko.helper.internal.HelperImplementationPlugin;
import me.lucko.helper.plugin.HelperPlugin;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class LoaderUtils {
    private static HelperPlugin plugin = null;
    private static Thread mainThread = null;

    @Nonnull
    public static synchronized HelperPlugin getPlugin() {
        if (plugin == null) {
            JavaPlugin pl = JavaPlugin.getProvidingPlugin(LoaderUtils.class);
            if (!(pl instanceof HelperPlugin)) {
                throw new IllegalStateException("helper providing plugin does not implement HelperPlugin: " + pl.getClass().getName());
            }
            plugin = (HelperPlugin)pl;
            String pkg = LoaderUtils.class.getPackage().getName();
            pkg = pkg.substring(0, pkg.length() - ".internal".length());
            Bukkit.getLogger().info("[helper] helper (" + pkg + ") bound to plugin " + plugin.getName() + " - " + plugin.getClass().getName());
            LoaderUtils.setup();
        }
        return plugin;
    }

    public static synchronized void forceSetPlugin(HelperPlugin plugin) {
        LoaderUtils.plugin = plugin;
    }

    public static Set<Plugin> getHelperImplementationPlugins() {
        return Stream.concat(Stream.of(LoaderUtils.getPlugin()), Arrays.stream(Helper.plugins().getPlugins()).filter(pl -> pl.getClass().isAnnotationPresent(HelperImplementationPlugin.class))).collect(Collectors.toSet());
    }

    public static Set<HelperPlugin> getHelperPlugins() {
        return Stream.concat(Stream.of(LoaderUtils.getPlugin()), Arrays.stream(Helper.plugins().getPlugins()).filter(pl -> pl instanceof HelperPlugin).map(pl -> (HelperPlugin)pl)).collect(Collectors.toSet());
    }

    @Nonnull
    public static synchronized Thread getMainThread() {
        if (mainThread == null && Bukkit.getServer().isPrimaryThread()) {
            mainThread = Thread.currentThread();
        }
        return mainThread;
    }

    private static void setup() {
        LoaderUtils.getMainThread();
    }

    private LoaderUtils() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

