/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.hologram;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.lucko.helper.hologram.Hologram;
import me.lucko.helper.serialize.Position;

public interface HologramFactory {
    @Nonnull
    public Hologram newHologram(@Nonnull Position var1, @Nonnull List<String> var2);

    @Nonnull
    default public Hologram deserialize(JsonElement element) {
        Preconditions.checkArgument((boolean)element.isJsonObject());
        JsonObject object = element.getAsJsonObject();
        Preconditions.checkArgument((boolean)object.has("position"));
        Preconditions.checkArgument((boolean)object.has("lines"));
        Position position = Position.deserialize(object.get("position"));
        JsonArray lineArray = object.get("lines").getAsJsonArray();
        ArrayList<String> lines = new ArrayList<String>();
        for (JsonElement e : lineArray) {
            lines.add(e.getAsString());
        }
        return this.newHologram(position, lines);
    }
}

