/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.reactive;

import java.util.Iterator;
import java.util.concurrent.Executor;
import me.lucko.helper.config.reactive.AbstractProcessor;
import me.lucko.helper.config.reactive.Processor;
import me.lucko.helper.config.reactive.RegistrationImpl;
import me.lucko.helper.config.reactive.Subscriber;

class ProcessorImpl<V>
extends AbstractProcessor<V, RegistrationImpl<V>>
implements Processor.Iso<V> {
    ProcessorImpl(Executor exec) {
        super(exec);
    }

    @Override
    public void submit(V value) {
        if (this.subscriberCount.get() >= 0) {
            Subscriber fallback;
            boolean handled = false;
            Iterator it = this.registrations.iterator();
            while (it.hasNext()) {
                RegistrationImpl reg = (RegistrationImpl)it.next();
                try {
                    handled = true;
                    reg.submit(value);
                }
                catch (Throwable t) {
                    it.remove();
                    this.subscriberCount.getAndDecrement();
                    reg.subscriber.onError(t);
                }
            }
            if (!handled && (fallback = this.fallbackHandler) != null) {
                fallback.submit(value);
            }
        }
    }

    @Override
    protected RegistrationImpl<V> createRegistration(Subscriber<? super V> sub) {
        return new RegistrationImpl<V>(this, sub);
    }
}

