/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import me.lucko.helper.config.ConfigurationException;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.commented.CommentedConfigurationNode;
import me.lucko.helper.config.gson.GsonConfigurationLoader;
import me.lucko.helper.config.hocon.HoconConfigurationLoader;
import me.lucko.helper.config.loader.ConfigurationLoader;
import me.lucko.helper.config.objectmapping.ObjectMapper;
import me.lucko.helper.config.objectmapping.ObjectMappingException;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializerCollection;
import me.lucko.helper.config.typeserializers.BukkitTypeSerializer;
import me.lucko.helper.config.typeserializers.ColoredStringTypeSerializer;
import me.lucko.helper.config.typeserializers.GsonTypeSerializer;
import me.lucko.helper.config.typeserializers.HelperTypeSerializer;
import me.lucko.helper.config.typeserializers.JsonTreeTypeSerializer;
import me.lucko.helper.config.typeserializers.Text3TypeSerializer;
import me.lucko.helper.config.typeserializers.TextTypeSerializer;
import me.lucko.helper.config.yaml.YAMLConfigurationLoader;
import me.lucko.helper.datatree.DataTree;
import me.lucko.helper.gson.GsonSerializable;
import me.lucko.helper.text.Component;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.yaml.snakeyaml.DumperOptions;

public abstract class ConfigFactory<N extends ConfigurationNode, L extends ConfigurationLoader<N>> {
    private static final ConfigFactory<ConfigurationNode, YAMLConfigurationLoader> YAML = new ConfigFactory<ConfigurationNode, YAMLConfigurationLoader>(){

        @Override
        @Nonnull
        public YAMLConfigurationLoader loader(@Nonnull Path path) {
            YAMLConfigurationLoader.Builder builder = (YAMLConfigurationLoader.Builder)((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setFlowStyle(DumperOptions.FlowStyle.BLOCK).setIndent(2).setSource(() -> Files.newBufferedReader(path, StandardCharsets.UTF_8))).setSink(() -> Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]));
            builder.setDefaultOptions(builder.getDefaultOptions().withSerializers(TYPE_SERIALIZERS));
            return builder.build();
        }
    };
    private static final ConfigFactory<ConfigurationNode, GsonConfigurationLoader> GSON = new ConfigFactory<ConfigurationNode, GsonConfigurationLoader>(){

        @Override
        @Nonnull
        public GsonConfigurationLoader loader(@Nonnull Path path) {
            GsonConfigurationLoader.Builder builder = (GsonConfigurationLoader.Builder)((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().setIndent(2).setSource(() -> Files.newBufferedReader(path, StandardCharsets.UTF_8))).setSink(() -> Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]));
            builder.setDefaultOptions(builder.getDefaultOptions().withSerializers(TYPE_SERIALIZERS));
            return builder.build();
        }
    };
    private static final ConfigFactory<CommentedConfigurationNode, HoconConfigurationLoader> HOCON = new ConfigFactory<CommentedConfigurationNode, HoconConfigurationLoader>(){

        @Override
        @Nonnull
        public HoconConfigurationLoader loader(@Nonnull Path path) {
            HoconConfigurationLoader.Builder builder = (HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setSource(() -> Files.newBufferedReader(path, StandardCharsets.UTF_8))).setSink(() -> Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]));
            builder.setDefaultOptions(builder.getDefaultOptions().withSerializers(TYPE_SERIALIZERS));
            return builder.build();
        }
    };
    private static final TypeSerializerCollection TYPE_SERIALIZERS;

    @Nonnull
    public static TypeSerializerCollection typeSerializers() {
        return TYPE_SERIALIZERS;
    }

    @Nonnull
    public static ConfigFactory<ConfigurationNode, YAMLConfigurationLoader> yaml() {
        return YAML;
    }

    @Nonnull
    public static ConfigFactory<ConfigurationNode, GsonConfigurationLoader> gson() {
        return GSON;
    }

    @Nonnull
    public static ConfigFactory<CommentedConfigurationNode, HoconConfigurationLoader> hocon() {
        return HOCON;
    }

    private ConfigFactory() {
    }

    @Nonnull
    public abstract L loader(@Nonnull Path var1);

    @Nonnull
    public N load(@Nonnull Path path) {
        try {
            return (N)this.loader(path).load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void save(@Nonnull Path path, @Nonnull ConfigurationNode node) {
        try {
            this.loader(path).save(node);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void load(@Nonnull Path path, T object) {
        try {
            L loader = this.loader(path);
            ObjectMapper.BoundInstance mapper = ConfigFactory.objectMapper(object);
            if (!Files.exists(path, new LinkOption[0])) {
                Object node = loader.createEmptyNode();
                mapper.serialize((ConfigurationNode)node);
                loader.save((ConfigurationNode)node);
            } else {
                Object node = loader.load();
                mapper.populate((ConfigurationNode)node);
            }
        }
        catch (IOException | ObjectMappingException e) {
            throw new ConfigurationException(e);
        }
    }

    @Nonnull
    public L loader(@Nonnull File file) {
        return this.loader(file.toPath());
    }

    @Nonnull
    public N load(@Nonnull File file) {
        return this.load(file.toPath());
    }

    public void save(@Nonnull File file, @Nonnull ConfigurationNode node) {
        this.save(file.toPath(), node);
    }

    public <T> void load(@Nonnull File file, T object) {
        this.load(file.toPath(), object);
    }

    @Nonnull
    public static <T> ObjectMapper<T> classMapper(@Nonnull Class<T> clazz) {
        try {
            return ObjectMapper.forClass(clazz);
        }
        catch (ObjectMappingException e) {
            throw new ConfigurationException(e);
        }
    }

    @Nonnull
    public static <T> ObjectMapper.BoundInstance objectMapper(@Nonnull T object) {
        try {
            return ObjectMapper.forObject(object);
        }
        catch (ObjectMappingException e) {
            throw new ConfigurationException(e);
        }
    }

    @Nonnull
    public static <T> T generate(@Nonnull Class<T> clazz, @Nonnull ConfigurationNode node) {
        try {
            return ConfigFactory.classMapper(clazz).bindToNew().populate(node);
        }
        catch (ObjectMappingException e) {
            throw new ConfigurationException(e);
        }
    }

    @Nonnull
    public static <T> T populate(@Nonnull T object, @Nonnull ConfigurationNode node) {
        try {
            return ConfigFactory.objectMapper(object).populate(node);
        }
        catch (ObjectMappingException e) {
            throw new ConfigurationException(e);
        }
    }

    static {
        TypeSerializerCollection helperSerializers = TypeSerializerCollection.create();
        helperSerializers.register(TypeToken.of(JsonElement.class), GsonTypeSerializer.INSTANCE);
        helperSerializers.register(TypeToken.of(GsonSerializable.class), HelperTypeSerializer.INSTANCE);
        helperSerializers.register(TypeToken.of(ConfigurationSerializable.class), BukkitTypeSerializer.INSTANCE);
        helperSerializers.register(TypeToken.of(DataTree.class), JsonTreeTypeSerializer.INSTANCE);
        helperSerializers.register(TypeToken.of(String.class), ColoredStringTypeSerializer.INSTANCE);
        helperSerializers.register(TypeToken.of(Component.class), TextTypeSerializer.INSTANCE);
        helperSerializers.register(TypeToken.of(me.lucko.helper.text3.Component.class), Text3TypeSerializer.INSTANCE);
        TYPE_SERIALIZERS = helperSerializers.newChild();
    }
}

