/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.command.context;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.command.argument.Argument;
import me.lucko.helper.command.argument.SimpleArgument;
import me.lucko.helper.command.context.CommandContext;
import org.bukkit.command.CommandSender;

public class ImmutableCommandContext<T extends CommandSender>
implements CommandContext<T> {
    private final T sender;
    private final String label;
    private final ImmutableList<String> args;
    private final ImmutableList<String> aliases;

    public ImmutableCommandContext(T sender, String label, String[] args, List<String> aliases) {
        this.sender = sender;
        this.label = label;
        this.args = ImmutableList.copyOf((Object[])args);
        this.aliases = ImmutableList.copyOf(aliases);
    }

    @Override
    @Nonnull
    public T sender() {
        return this.sender;
    }

    @Override
    @Nonnull
    public ImmutableList<String> args() {
        return this.args;
    }

    @Override
    @Nonnull
    public Argument arg(int index) {
        return new SimpleArgument(index, this.rawArg(index));
    }

    @Override
    @Nullable
    public String rawArg(int index) {
        if (index < 0 || index >= this.args.size()) {
            return null;
        }
        return (String)this.args.get(index);
    }

    @Override
    @Nonnull
    public String label() {
        return this.label;
    }

    @Nonnull
    public ImmutableList<String> aliases() {
        return this.aliases;
    }
}

