/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.serialize;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.Helper;
import me.lucko.helper.gson.GsonSerializable;
import me.lucko.helper.gson.JsonBuilder;
import me.lucko.helper.serialize.Direction;
import me.lucko.helper.serialize.Position;
import me.lucko.helper.serialize.VectorPoint;
import org.bukkit.Location;

public final class Point
implements GsonSerializable {
    private final Position position;
    private final Direction direction;
    @Nullable
    private Location bukkitLocation = null;

    public static Point deserialize(JsonElement element) {
        Position position = Position.deserialize(element);
        Direction direction = Direction.deserialize(element);
        return Point.of(position, direction);
    }

    public static Point of(Position position, Direction direction) {
        Objects.requireNonNull(position, "position");
        Objects.requireNonNull(direction, "direction");
        return new Point(position, direction);
    }

    public static Point of(Location location) {
        Objects.requireNonNull(location, "location");
        return Point.of(Position.of(location), Direction.from(location));
    }

    private Point(Position position, Direction direction) {
        this.position = position;
        this.direction = direction;
    }

    public Position getPosition() {
        return this.position;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public synchronized Location toLocation() {
        if (this.bukkitLocation == null) {
            this.bukkitLocation = new Location(Helper.worldNullable(this.position.getWorld()), this.position.getX(), this.position.getY(), this.position.getZ(), this.direction.getYaw(), this.direction.getPitch());
        }
        return this.bukkitLocation.clone();
    }

    public VectorPoint toVectorPoint() {
        return VectorPoint.of(this);
    }

    public Point add(double x, double y, double z) {
        return this.position.add(x, y, z).withDirection(this.direction);
    }

    public Point subtract(double x, double y, double z) {
        return this.position.subtract(x, y, z).withDirection(this.direction);
    }

    @Nonnull
    public JsonObject serialize() {
        return JsonBuilder.object().addAll(this.position.serialize()).addAll(this.direction.serialize()).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point)) {
            return false;
        }
        Point other = (Point)o;
        return this.getPosition().equals(other.getPosition()) && this.getDirection().equals(other.getDirection());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPosition().hashCode();
        result = result * 59 + this.getDirection().hashCode();
        return result;
    }

    public String toString() {
        return "Point(position=" + this.getPosition() + ", direction=" + this.getDirection() + ")";
    }
}

