/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.nbt;

import me.lucko.helper.shadows.nbt.NBTBase;
import me.lucko.helper.shadows.nbt.NBTTagByte;
import me.lucko.helper.shadows.nbt.NBTTagByteArray;
import me.lucko.helper.shadows.nbt.NBTTagCompound;
import me.lucko.helper.shadows.nbt.NBTTagDouble;
import me.lucko.helper.shadows.nbt.NBTTagEnd;
import me.lucko.helper.shadows.nbt.NBTTagFloat;
import me.lucko.helper.shadows.nbt.NBTTagInt;
import me.lucko.helper.shadows.nbt.NBTTagIntArray;
import me.lucko.helper.shadows.nbt.NBTTagList;
import me.lucko.helper.shadows.nbt.NBTTagLong;
import me.lucko.helper.shadows.nbt.NBTTagLongArray;
import me.lucko.helper.shadows.nbt.NBTTagShort;
import me.lucko.helper.shadows.nbt.NBTTagString;

public enum NBTTagType {
    END(NBTTagEnd.class, 0),
    BYTE(NBTTagByte.class, 1, true),
    SHORT(NBTTagShort.class, 2, true),
    INT(NBTTagInt.class, 3, true),
    LONG(NBTTagLong.class, 4, true),
    FLOAT(NBTTagFloat.class, 5, true),
    DOUBLE(NBTTagDouble.class, 6, true),
    BYTE_ARRAY(NBTTagByteArray.class, 7),
    STRING(NBTTagString.class, 8),
    LIST(NBTTagList.class, 9),
    COMPOUND(NBTTagCompound.class, 10),
    INT_ARRAY(NBTTagIntArray.class, 11),
    LONG_ARRAY(NBTTagLongArray.class, 12);

    private static final NBTTagType[] TYPES;
    private final Class<? extends NBTBase> shadowClass;
    private final byte id;
    private final boolean number;

    public static NBTTagType of(byte id) {
        return TYPES[id];
    }

    private NBTTagType(Class<? extends NBTBase> shadowClass, byte id) {
        this(shadowClass, id, false);
    }

    private NBTTagType(Class<? extends NBTBase> shadowClass, byte id, boolean number) {
        this.shadowClass = shadowClass;
        this.id = id;
        this.number = number;
    }

    public Class<? extends NBTBase> shadowClass() {
        return this.shadowClass;
    }

    public byte id() {
        return this.id;
    }

    public boolean number() {
        return this.number;
    }

    static {
        TYPES = NBTTagType.values();
    }
}

