/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.item;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import me.lucko.helper.item.ItemStackBuilder;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;

public class ItemStackReader {
    public static final ItemStackReader DEFAULT = new ItemStackReader();

    protected ItemStackReader() {
    }

    public final ItemStackBuilder read(ConfigurationSection config) {
        return this.read(config, VariableReplacer.NOOP);
    }

    public ItemStackBuilder read(ConfigurationSection config, VariableReplacer variableReplacer) {
        return ItemStackBuilder.of(this.parseMaterial(config)).apply(isb -> {
            this.parseData(config).ifPresent(isb::data);
            this.parseName(config).map(variableReplacer::replace).ifPresent(isb::name);
            this.parseLore(config).map(variableReplacer::replace).ifPresent(isb::lore);
        });
    }

    protected Material parseMaterial(ConfigurationSection config) {
        return this.parseMaterial(config.getString("material"));
    }

    protected Material parseMaterial(String name) {
        try {
            return Material.valueOf((String)name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unable to parse material '" + name + "'");
        }
    }

    protected OptionalInt parseData(ConfigurationSection config) {
        if (config.contains("data")) {
            return OptionalInt.of(config.getInt("data"));
        }
        return OptionalInt.empty();
    }

    protected Optional<String> parseName(ConfigurationSection config) {
        if (config.contains("name")) {
            return Optional.of(config.getString("name"));
        }
        return Optional.empty();
    }

    protected Optional<List<String>> parseLore(ConfigurationSection config) {
        if (config.contains("lore")) {
            return Optional.of(config.getStringList("lore"));
        }
        return Optional.empty();
    }

    @FunctionalInterface
    public static interface VariableReplacer {
        public static final VariableReplacer NOOP = string -> string;

        public String replace(String var1);

        default public Iterable<String> replace(List<String> list) {
            return Iterables.transform(list, this::replace);
        }
    }
}

