/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper;

import java.util.Optional;
import javax.annotation.Nullable;
import me.lucko.helper.Services;
import me.lucko.helper.internal.LoaderUtils;
import me.lucko.helper.plugin.HelperPlugin;
import me.lucko.helper.utils.annotation.NonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.scheduler.BukkitScheduler;

@NonnullByDefault
public final class Helper {
    public static HelperPlugin hostPlugin() {
        return LoaderUtils.getPlugin();
    }

    public static Server server() {
        return Bukkit.getServer();
    }

    public static ConsoleCommandSender console() {
        return Helper.server().getConsoleSender();
    }

    public static PluginManager plugins() {
        return Helper.server().getPluginManager();
    }

    public static ServicesManager services() {
        return Helper.server().getServicesManager();
    }

    public static BukkitScheduler bukkitScheduler() {
        return Helper.server().getScheduler();
    }

    @Nullable
    public static <T> T serviceNullable(Class<T> clazz) {
        return Services.get(clazz).orElse(null);
    }

    public static <T> Optional<T> service(Class<T> clazz) {
        return Services.get(clazz);
    }

    public static void executeCommand(String command) {
        Helper.server().dispatchCommand((CommandSender)Helper.console(), command);
    }

    @Nullable
    public static World worldNullable(String name) {
        return Helper.server().getWorld(name);
    }

    public static Optional<World> world(String name) {
        return Optional.ofNullable(Helper.worldNullable(name));
    }

    private Helper() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

