/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.plugin;

import java.io.File;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.Schedulers;
import me.lucko.helper.Services;
import me.lucko.helper.config.ConfigFactory;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.internal.LoaderUtils;
import me.lucko.helper.maven.LibraryLoader;
import me.lucko.helper.plugin.HelperPlugin;
import me.lucko.helper.terminable.composite.CompositeTerminable;
import me.lucko.helper.terminable.module.TerminableModule;
import me.lucko.helper.utils.CommandMapUtil;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class ExtendedJavaPlugin
extends JavaPlugin
implements HelperPlugin {
    private CompositeTerminable terminableRegistry;

    protected void load() {
    }

    protected void enable() {
    }

    protected void disable() {
    }

    public final void onLoad() {
        LoaderUtils.getPlugin();
        this.terminableRegistry = CompositeTerminable.create();
        LibraryLoader.loadAll(this.getClass());
        this.load();
    }

    public final void onEnable() {
        Schedulers.builder().async().after(10L, TimeUnit.SECONDS).every(30L, TimeUnit.SECONDS).run(this.terminableRegistry::cleanup).bindWith(this.terminableRegistry);
        this.enable();
    }

    public final void onDisable() {
        this.disable();
        this.terminableRegistry.closeAndReportException();
    }

    @Override
    @Nonnull
    public <T extends AutoCloseable> T bind(@Nonnull T terminable) {
        return this.terminableRegistry.bind(terminable);
    }

    @Override
    @Nonnull
    public <T extends TerminableModule> T bindModule(@Nonnull T module) {
        return this.terminableRegistry.bindModule(module);
    }

    @Override
    @Nonnull
    public <T extends Listener> T registerListener(@Nonnull T listener) {
        Objects.requireNonNull(listener, "listener");
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
        return listener;
    }

    @Override
    @Nonnull
    public <T extends CommandExecutor> T registerCommand(@Nonnull T command, String permission, String permissionMessage, String description, String ... aliases) {
        return CommandMapUtil.registerCommand((Plugin)this, command, permission, permissionMessage, description, aliases);
    }

    @Override
    @Nonnull
    public <T> T getService(@Nonnull Class<T> service) {
        return Services.load(service);
    }

    @Override
    @Nonnull
    public <T> T provideService(@Nonnull Class<T> clazz, @Nonnull T instance, @Nonnull ServicePriority priority) {
        return Services.provide(clazz, instance, this, priority);
    }

    @Override
    @Nonnull
    public <T> T provideService(@Nonnull Class<T> clazz, @Nonnull T instance) {
        return this.provideService(clazz, instance, ServicePriority.Normal);
    }

    @Override
    public boolean isPluginPresent(@Nonnull String name) {
        return this.getServer().getPluginManager().getPlugin(name) != null;
    }

    @Override
    @Nullable
    public <T> T getPlugin(@Nonnull String name, @Nonnull Class<T> pluginClass) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(pluginClass, "pluginClass");
        return (T)this.getServer().getPluginManager().getPlugin(name);
    }

    private File getRelativeFile(@Nonnull String name) {
        this.getDataFolder().mkdirs();
        return new File(this.getDataFolder(), name);
    }

    @Override
    @Nonnull
    public File getBundledFile(@Nonnull String name) {
        Objects.requireNonNull(name, "name");
        File file = this.getRelativeFile(name);
        if (!file.exists()) {
            this.saveResource(name, false);
        }
        return file;
    }

    @Override
    @Nonnull
    public YamlConfiguration loadConfig(@Nonnull String file) {
        Objects.requireNonNull(file, "file");
        return YamlConfiguration.loadConfiguration((File)this.getBundledFile(file));
    }

    @Override
    @Nonnull
    public ConfigurationNode loadConfigNode(@Nonnull String file) {
        Objects.requireNonNull(file, "file");
        return ConfigFactory.yaml().load(this.getBundledFile(file));
    }

    @Override
    @Nonnull
    public <T> T setupConfig(@Nonnull String file, @Nonnull T configObject) {
        Objects.requireNonNull(file, "file");
        Objects.requireNonNull(configObject, "configObject");
        File f = this.getRelativeFile(file);
        ConfigFactory.yaml().load(f, configObject);
        return configObject;
    }

    @Override
    @Nonnull
    public ClassLoader getClassloader() {
        return super.getClassLoader();
    }
}

