/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.network.modules;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import me.lucko.helper.Commands;
import me.lucko.helper.network.Network;
import me.lucko.helper.network.Server;
import me.lucko.helper.terminable.TerminableConsumer;
import me.lucko.helper.terminable.module.TerminableModule;
import me.lucko.helper.utils.Players;

public class FindCommandModule
implements TerminableModule {
    private final Network network;
    private final String[] commandAliases;

    public FindCommandModule(Network network) {
        this(network, new String[]{"find"});
    }

    public FindCommandModule(Network network, String[] commandAliases) {
        this.network = network;
        this.commandAliases = commandAliases;
    }

    @Override
    public void setup(@Nonnull TerminableConsumer consumer) {
        Commands.create().assertPermission("helper.find").handler(c -> {
            String player = c.arg(0).parseOrFail(String.class).toLowerCase();
            Map matches = this.network.getServers().entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, s -> ((Server)s.getValue()).getOnlinePlayers().values().stream().filter(p -> p.getName().isPresent() && p.getName().get().toLowerCase().contains(player)).sorted(Comparator.comparing(p -> p.getName().get())).collect(Collectors.toList()), (l1, l2) -> Stream.concat(l1.stream(), l2.stream()).collect(Collectors.toList()), LinkedHashMap::new));
            matches.values().removeIf(Collection::isEmpty);
            if (matches.isEmpty()) {
                Players.msg(c.sender(), new String[]{"&7[&anetwork&7] &7No players found matching '&f" + player + "&7'."});
            } else {
                Players.msg(c.sender(), new String[]{"&7[&anetwork&7] &7Player search results for '&f" + player + "&7':"});
                matches.forEach((server, profiles) -> profiles.forEach(profile -> Players.msg(c.sender(), new String[]{"&7[&anetwork&7] &f> &2" + profile.getName().orElse(profile.getUniqueId().toString()) + " &7connected to &2" + server})));
            }
        }).registerAndBind(consumer, this.commandAliases);
    }
}

