/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.function;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Numbers {
    @Nullable
    public static Number parseNullable(@Nonnull String s) {
        Objects.requireNonNull(s);
        try {
            return NumberFormat.getInstance().parse(s);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Nonnull
    public static Optional<Number> parse(@Nonnull String s) {
        return Optional.ofNullable(Numbers.parseNullable(s));
    }

    @Nullable
    public static Integer parseIntegerNullable(@Nonnull String s) {
        Objects.requireNonNull(s);
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nonnull
    public static Optional<Integer> parseIntegerOpt(@Nonnull String s) {
        return Optional.ofNullable(Numbers.parseIntegerNullable(s));
    }

    @Nonnull
    public static OptionalInt parseInteger(@Nonnull String s) {
        try {
            return OptionalInt.of(Integer.parseInt(s));
        }
        catch (NumberFormatException e) {
            return OptionalInt.empty();
        }
    }

    @Nullable
    public static Long parseLongNullable(@Nonnull String s) {
        Objects.requireNonNull(s);
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nonnull
    public static Optional<Long> parseLongOpt(@Nonnull String s) {
        return Optional.ofNullable(Numbers.parseLongNullable(s));
    }

    @Nonnull
    public static OptionalLong parseLong(@Nonnull String s) {
        try {
            return OptionalLong.of(Long.parseLong(s));
        }
        catch (NumberFormatException e) {
            return OptionalLong.empty();
        }
    }

    @Nullable
    public static Float parseFloatNullable(@Nonnull String s) {
        Objects.requireNonNull(s);
        try {
            return Float.valueOf(Float.parseFloat(s));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nonnull
    public static Optional<Float> parseFloatOpt(@Nonnull String s) {
        return Optional.ofNullable(Numbers.parseFloatNullable(s));
    }

    @Nonnull
    public static OptionalDouble parseFloat(@Nonnull String s) {
        try {
            return OptionalDouble.of(Float.parseFloat(s));
        }
        catch (NumberFormatException e) {
            return OptionalDouble.empty();
        }
    }

    @Nullable
    public static Double parseDoubleNullable(@Nonnull String s) {
        Objects.requireNonNull(s);
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nonnull
    public static Optional<Double> parseDoubleOpt(@Nonnull String s) {
        return Optional.ofNullable(Numbers.parseDoubleNullable(s));
    }

    @Nonnull
    public static OptionalDouble parseDouble(@Nonnull String s) {
        try {
            return OptionalDouble.of(Double.parseDouble(s));
        }
        catch (NumberFormatException e) {
            return OptionalDouble.empty();
        }
    }

    @Nullable
    public static Byte parseByteNullable(@Nonnull String s) {
        Objects.requireNonNull(s);
        try {
            return Byte.parseByte(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nonnull
    public static Optional<Byte> parseByteOpt(@Nonnull String s) {
        return Optional.ofNullable(Numbers.parseByteNullable(s));
    }

    private Numbers() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

