/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.commented;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.ConfigurationOptions;
import me.lucko.helper.config.SimpleConfigurationNode;
import me.lucko.helper.config.commented.CommentedConfigurationNode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SimpleCommentedConfigurationNode
extends SimpleConfigurationNode
implements CommentedConfigurationNode {
    private String comment = null;

    public static @NonNull SimpleCommentedConfigurationNode root() {
        return SimpleCommentedConfigurationNode.root(ConfigurationOptions.defaults());
    }

    public static @NonNull SimpleCommentedConfigurationNode root(@NonNull ConfigurationOptions options) {
        return new SimpleCommentedConfigurationNode(null, null, options);
    }

    protected SimpleCommentedConfigurationNode(@Nullable Object path, @Nullable SimpleConfigurationNode parent, @NonNull ConfigurationOptions options) {
        super(path, parent, options);
    }

    protected SimpleCommentedConfigurationNode(@Nullable SimpleConfigurationNode parent, @NonNull SimpleConfigurationNode copyOf) {
        super(parent, copyOf);
    }

    @Override
    public @NonNull Optional<String> getComment() {
        return Optional.ofNullable(this.comment);
    }

    @Override
    public @NonNull SimpleCommentedConfigurationNode setComment(@Nullable String comment) {
        this.attachIfNecessary();
        this.comment = comment;
        return this;
    }

    @Override
    public @Nullable SimpleCommentedConfigurationNode getParent() {
        return (SimpleCommentedConfigurationNode)super.getParent();
    }

    @Override
    protected SimpleCommentedConfigurationNode createNode(Object path) {
        return new SimpleCommentedConfigurationNode(path, this, this.getOptions());
    }

    @Override
    public @NonNull SimpleCommentedConfigurationNode setValue(@Nullable Object value) {
        if (value instanceof CommentedConfigurationNode && ((CommentedConfigurationNode)value).getComment().isPresent()) {
            this.setComment(((CommentedConfigurationNode)value).getComment().get());
        }
        return (SimpleCommentedConfigurationNode)super.setValue(value);
    }

    @Override
    public @NonNull SimpleCommentedConfigurationNode mergeValuesFrom(@NonNull ConfigurationNode other) {
        if (other instanceof CommentedConfigurationNode) {
            Optional<String> otherComment = ((CommentedConfigurationNode)other).getComment();
            if (this.comment == null && otherComment.isPresent()) {
                this.comment = otherComment.get();
            }
        }
        return (SimpleCommentedConfigurationNode)super.mergeValuesFrom(other);
    }

    @Override
    public @NonNull SimpleCommentedConfigurationNode getNode(Object ... path) {
        return (SimpleCommentedConfigurationNode)super.getNode(path);
    }

    public @NonNull List<? extends SimpleCommentedConfigurationNode> getChildrenList() {
        return super.getChildrenList();
    }

    public @NonNull Map<Object, ? extends SimpleCommentedConfigurationNode> getChildrenMap() {
        return super.getChildrenMap();
    }

    @Override
    public @NonNull SimpleCommentedConfigurationNode getAppendedNode() {
        return (SimpleCommentedConfigurationNode)super.getAppendedNode();
    }

    @Override
    public @NonNull SimpleCommentedConfigurationNode copy() {
        return this.copy(null);
    }

    @Override
    protected @NonNull SimpleCommentedConfigurationNode copy(@Nullable SimpleConfigurationNode parent) {
        SimpleCommentedConfigurationNode copy = new SimpleCommentedConfigurationNode(parent, this);
        copy.comment = this.comment;
        return copy;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleCommentedConfigurationNode)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SimpleCommentedConfigurationNode that = (SimpleCommentedConfigurationNode)o;
        return Objects.equals(this.comment, that.comment);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.comment);
        return result;
    }

    @Override
    public String toString() {
        return "SimpleCommentedConfigurationNode{super=" + super.toString() + ", comment=" + this.comment + '}';
    }
}

