/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.network.modules;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import me.lucko.helper.Commands;
import me.lucko.helper.Events;
import me.lucko.helper.Schedulers;
import me.lucko.helper.event.filter.EventFilters;
import me.lucko.helper.messaging.InstanceData;
import me.lucko.helper.network.Network;
import me.lucko.helper.terminable.TerminableConsumer;
import me.lucko.helper.terminable.module.TerminableModule;
import me.lucko.helper.utils.Players;
import me.lucko.helper.utils.TimeUtil;
import me.lucko.helper.utils.Tps;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;

public class NetworkSummaryModule
implements TerminableModule {
    private final Network network;
    private final InstanceData instanceData;
    private final String[] commandAliases;

    public NetworkSummaryModule(Network network, InstanceData instanceData) {
        this(network, instanceData, new String[]{"networksummary", "netsum"});
    }

    public NetworkSummaryModule(Network network, InstanceData instanceData, String[] commandAliases) {
        this.network = network;
        this.instanceData = instanceData;
        this.commandAliases = commandAliases;
    }

    @Override
    public void setup(@Nonnull TerminableConsumer consumer) {
        Commands.create().assertPermission("helper.networksummary").handler(c -> this.sendSummary((CommandSender)c.sender())).registerAndBind(consumer, this.commandAliases);
        Events.subscribe(PlayerJoinEvent.class, EventPriority.MONITOR).filter(EventFilters.playerHasPermission("helper.networksummary.onjoin")).handler(e -> Schedulers.sync().runLater(() -> this.sendSummary((CommandSender)e.getPlayer()), 1L)).bindWith(consumer);
    }

    public void sendSummary(CommandSender sender) {
        Players.msg(sender, "&7[&anetwork&7] &f< Network summary >.");
        Players.msg(sender, "&7[&anetwork&7] &7" + this.network.getOverallPlayerCount() + " total players online.");
        Players.msg(sender, "&7[&anetwork&7]");
        this.network.getServers().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).forEach(server -> {
            String id = (server.getId().equals(this.instanceData.getId()) ? "&a" : "&b") + server.getId();
            if (!server.isOnline()) {
                long lastPing = server.getLastPing();
                if (lastPing == 0L) {
                    return;
                }
                long millisSinceLastSeen = TimeUtil.now() - lastPing;
                String lastSeen = TimeUtil.toShortForm(TimeUnit.MILLISECONDS.toSeconds(millisSinceLastSeen));
                Players.msg(sender, "&7[&anetwork&7] " + id + " &7- last online " + lastSeen + " ago");
            } else {
                Tps tps = server.getMetadata("tps", Tps.class);
                String tpsInfo = "";
                if (tps != null) {
                    tpsInfo = " &7- " + tps.toFormattedString();
                }
                Players.msg(sender, "&7[&anetwork&7] " + id + " &7- &b" + server.getOnlinePlayers().size() + "&7/" + server.getMaxPlayers() + tpsInfo);
            }
        });
    }
}

