/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.hologram;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.Events;
import me.lucko.helper.gson.JsonBuilder;
import me.lucko.helper.hologram.Hologram;
import me.lucko.helper.hologram.HologramFactory;
import me.lucko.helper.reflect.MinecraftVersion;
import me.lucko.helper.reflect.MinecraftVersions;
import me.lucko.helper.serialize.Position;
import me.lucko.helper.terminable.composite.CompositeTerminable;
import me.lucko.helper.text.Text;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;

public class BukkitHologramFactory
implements HologramFactory {
    @Override
    @Nonnull
    public Hologram newHologram(@Nonnull Position position, @Nonnull List<String> lines) {
        return new BukkitHologram(position, lines);
    }

    private static final class BukkitHologram
    implements Hologram {
        private Position position;
        private final List<String> lines = new ArrayList<String>();
        private final List<ArmorStand> spawnedEntities = new ArrayList<ArmorStand>();
        private boolean spawned = false;
        private CompositeTerminable listeners = null;
        private Consumer<Player> clickCallback = null;

        BukkitHologram(Position position, List<String> lines) {
            this.position = Objects.requireNonNull(position, "position");
            this.updateLines(lines);
        }

        private Position getNewLinePosition() {
            if (this.spawnedEntities.isEmpty()) {
                return this.position;
            }
            ArmorStand last = this.spawnedEntities.get(this.spawnedEntities.size() - 1);
            return Position.of(last.getLocation()).subtract(0.0, 0.25, 0.0);
        }

        @Override
        public void spawn() {
            ArmorStand as;
            int spawnedSize;
            int linesSize = this.lines.size();
            if (linesSize < (spawnedSize = this.spawnedEntities.size())) {
                int diff = spawnedSize - linesSize;
                for (int i = 0; i < diff; ++i) {
                    as = this.spawnedEntities.remove(this.spawnedEntities.size() - 1);
                    as.remove();
                }
            }
            for (int i = 0; i < this.lines.size(); ++i) {
                String line = this.lines.get(i);
                if (i >= this.spawnedEntities.size()) {
                    Location loc = this.getNewLinePosition().toLocation();
                    Chunk chunk = loc.getChunk();
                    if (!chunk.isLoaded()) {
                        chunk.load();
                    }
                    loc.getWorld().getNearbyEntities(loc, 1.0, 1.0, 1.0).forEach(e -> {
                        if (e.getType() == EntityType.ARMOR_STAND && BukkitHologram.locationsEqual(e.getLocation(), loc)) {
                            e.remove();
                        }
                    });
                    ArmorStand as2 = (ArmorStand)loc.getWorld().spawn(loc, ArmorStand.class);
                    as2.setSmall(true);
                    as2.setMarker(true);
                    as2.setArms(false);
                    as2.setBasePlate(false);
                    as2.setGravity(false);
                    as2.setVisible(false);
                    as2.setCustomName(line);
                    as2.setCustomNameVisible(true);
                    if (MinecraftVersion.getRuntimeVersion().isAfterOrEq(MinecraftVersions.v1_9)) {
                        as2.setAI(false);
                        as2.setCollidable(false);
                        as2.setInvulnerable(true);
                    }
                    this.spawnedEntities.add(as2);
                    continue;
                }
                as = this.spawnedEntities.get(i);
                if (as.getCustomName() != null && as.getCustomName().equals(line)) continue;
                as.setCustomName(line);
            }
            if (this.listeners == null && this.clickCallback != null) {
                this.setClickCallback(this.clickCallback);
            }
            this.spawned = true;
        }

        @Override
        public void despawn() {
            this.spawnedEntities.forEach(Entity::remove);
            this.spawnedEntities.clear();
            this.spawned = false;
            if (this.listeners != null) {
                this.listeners.closeAndReportException();
            }
            this.listeners = null;
        }

        @Override
        public boolean isSpawned() {
            if (!this.spawned) {
                return false;
            }
            for (ArmorStand stand : this.spawnedEntities) {
                if (stand.isValid()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void updatePosition(@Nonnull Position position) {
            Objects.requireNonNull(position, "position");
            if (this.position.equals(position)) {
                return;
            }
            this.position = position;
            this.despawn();
            this.spawn();
        }

        @Override
        public void updateLines(@Nonnull List<String> lines) {
            Objects.requireNonNull(lines, "lines");
            Preconditions.checkArgument((!lines.isEmpty() ? 1 : 0) != 0, (Object)"lines cannot be empty");
            for (String line : lines) {
                Preconditions.checkArgument((line != null ? 1 : 0) != 0, (Object)"null line");
            }
            List ret = lines.stream().map(Text::colorize).collect(Collectors.toList());
            if (this.lines.equals(ret)) {
                return;
            }
            this.lines.clear();
            this.lines.addAll(ret);
        }

        @Override
        public void setClickCallback(@Nullable Consumer<Player> clickCallback) {
            if (clickCallback == null) {
                if (this.listeners != null) {
                    this.listeners.closeAndReportException();
                }
                this.clickCallback = null;
                this.listeners = null;
                return;
            }
            this.clickCallback = clickCallback;
            if (this.listeners == null) {
                this.listeners = CompositeTerminable.create();
                Events.subscribe(PlayerInteractAtEntityEvent.class).filter(e -> e.getRightClicked() instanceof ArmorStand).handler(e -> {
                    Player p = e.getPlayer();
                    ArmorStand as = (ArmorStand)e.getRightClicked();
                    for (ArmorStand spawned : this.spawnedEntities) {
                        if (!spawned.equals(as)) continue;
                        e.setCancelled(true);
                        this.clickCallback.accept(p);
                        return;
                    }
                }).bindWith(this.listeners);
                Events.subscribe(EntityDamageByEntityEvent.class).filter(e -> e.getEntity() instanceof ArmorStand).filter(e -> e.getDamager() instanceof Player).handler(e -> {
                    Player p = (Player)e.getDamager();
                    ArmorStand as = (ArmorStand)e.getEntity();
                    for (ArmorStand spawned : this.spawnedEntities) {
                        if (!spawned.equals(as)) continue;
                        e.setCancelled(true);
                        this.clickCallback.accept(p);
                        return;
                    }
                }).bindWith(this.listeners);
            }
        }

        @Override
        public void close() {
            this.despawn();
        }

        @Override
        public boolean isClosed() {
            return !this.spawned;
        }

        @Nonnull
        public JsonObject serialize() {
            return JsonBuilder.object().add("position", this.position).add("lines", (JsonElement)JsonBuilder.array().addStrings(this.lines).build()).build();
        }

        private static boolean locationsEqual(Location l1, Location l2) {
            return Double.doubleToLongBits(l1.getX()) == Double.doubleToLongBits(l2.getX()) && Double.doubleToLongBits(l1.getY()) == Double.doubleToLongBits(l2.getY()) && Double.doubleToLongBits(l1.getZ()) == Double.doubleToLongBits(l2.getZ());
        }
    }
}

