/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.event.functional.merged;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.lucko.helper.event.MergedSubscription;
import me.lucko.helper.event.functional.ExpiryTestStage;
import me.lucko.helper.event.functional.SubscriptionBuilder;
import me.lucko.helper.event.functional.merged.MergedHandlerList;
import me.lucko.helper.event.functional.merged.MergedSubscriptionBuilderImpl;
import me.lucko.helper.utils.Delegates;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;

public interface MergedSubscriptionBuilder<T>
extends SubscriptionBuilder<T> {
    @Nonnull
    public static <T> MergedSubscriptionBuilder<T> newBuilder(@Nonnull Class<T> handledClass) {
        Objects.requireNonNull(handledClass, "handledClass");
        return new MergedSubscriptionBuilderImpl(TypeToken.of(handledClass));
    }

    @Nonnull
    public static <T> MergedSubscriptionBuilder<T> newBuilder(@Nonnull TypeToken<T> type) {
        Objects.requireNonNull(type, "type");
        return new MergedSubscriptionBuilderImpl<T>(type);
    }

    @Nonnull
    @SafeVarargs
    public static <S extends Event> MergedSubscriptionBuilder<S> newBuilder(@Nonnull Class<S> superClass, Class<? extends S> ... eventClasses) {
        return MergedSubscriptionBuilder.newBuilder(superClass, EventPriority.NORMAL, eventClasses);
    }

    @Nonnull
    @SafeVarargs
    public static <S extends Event> MergedSubscriptionBuilder<S> newBuilder(@Nonnull Class<S> superClass, @Nonnull EventPriority priority, Class<? extends S> ... eventClasses) {
        Objects.requireNonNull(superClass, "superClass");
        Objects.requireNonNull(eventClasses, "eventClasses");
        Objects.requireNonNull(priority, "priority");
        if (eventClasses.length < 2) {
            throw new IllegalArgumentException("merge method used for only one subclass");
        }
        MergedSubscriptionBuilderImpl<Event> h = new MergedSubscriptionBuilderImpl<Event>(TypeToken.of(superClass));
        for (Class<? extends S> clazz : eventClasses) {
            h.bindEvent(clazz, priority, e -> e);
        }
        return h;
    }

    @Override
    @Nonnull
    default public MergedSubscriptionBuilder<T> expireIf(@Nonnull Predicate<T> predicate) {
        return this.expireIf(Delegates.predicateToBiPredicateSecond(predicate), ExpiryTestStage.PRE, ExpiryTestStage.POST_HANDLE);
    }

    @Override
    @Nonnull
    default public MergedSubscriptionBuilder<T> expireAfter(long duration, @Nonnull TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Preconditions.checkArgument((duration >= 1L ? 1 : 0) != 0, (Object)"duration < 1");
        long expiry = Math.addExact(System.currentTimeMillis(), unit.toMillis(duration));
        return this.expireIf((handler, event) -> System.currentTimeMillis() > expiry, ExpiryTestStage.PRE);
    }

    @Override
    @Nonnull
    default public MergedSubscriptionBuilder<T> expireAfter(long maxCalls) {
        Preconditions.checkArgument((maxCalls >= 1L ? 1 : 0) != 0, (Object)"maxCalls < 1");
        return this.expireIf((handler, event) -> handler.getCallCounter() >= maxCalls, ExpiryTestStage.PRE, ExpiryTestStage.POST_HANDLE);
    }

    @Override
    @Nonnull
    public MergedSubscriptionBuilder<T> filter(@Nonnull Predicate<T> var1);

    @Nonnull
    public MergedSubscriptionBuilder<T> expireIf(@Nonnull BiPredicate<MergedSubscription<T>, T> var1, ExpiryTestStage ... var2);

    @Nonnull
    public <E extends Event> MergedSubscriptionBuilder<T> bindEvent(@Nonnull Class<E> var1, @Nonnull Function<E, T> var2);

    @Nonnull
    public <E extends Event> MergedSubscriptionBuilder<T> bindEvent(@Nonnull Class<E> var1, @Nonnull EventPriority var2, @Nonnull Function<E, T> var3);

    @Nonnull
    public MergedSubscriptionBuilder<T> exceptionConsumer(@Nonnull BiConsumer<Event, Throwable> var1);

    @Nonnull
    public MergedHandlerList<T> handlers();

    @Nonnull
    default public MergedSubscription<T> handler(@Nonnull Consumer<? super T> handler) {
        return (MergedSubscription)this.handlers().consumer((Consumer)handler).register();
    }

    @Nonnull
    default public MergedSubscription<T> biHandler(@Nonnull BiConsumer<MergedSubscription<T>, ? super T> handler) {
        return (MergedSubscription)this.handlers().biConsumer(handler).register();
    }
}

