/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.cooldown;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import me.lucko.helper.cooldown.Cooldown;
import me.lucko.helper.cooldown.CooldownMap;

class CooldownMapImpl<T>
implements CooldownMap<T> {
    private final Cooldown base;
    private final LoadingCache<T, Cooldown> cache;

    CooldownMapImpl(final Cooldown base) {
        this.base = base;
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(base.getTimeout() + 10000L, TimeUnit.MILLISECONDS).build(new CacheLoader<T, Cooldown>(){

            public Cooldown load(@Nonnull T key) {
                return base.copy();
            }
        });
    }

    @Override
    @Nonnull
    public Cooldown getBase() {
        return this.base;
    }

    @Override
    @Nonnull
    public Cooldown get(@Nonnull T key) {
        Objects.requireNonNull(key, "key");
        return (Cooldown)this.cache.getUnchecked(key);
    }

    @Override
    public void put(@Nonnull T key, @Nonnull Cooldown cooldown) {
        Objects.requireNonNull(key, "key");
        Preconditions.checkArgument((cooldown.getTimeout() == this.base.getTimeout() ? 1 : 0) != 0, (Object)"different timeout");
        this.cache.put(key, (Object)cooldown);
    }

    @Override
    @Nonnull
    public Map<T, Cooldown> getAll() {
        return this.cache.asMap();
    }
}

