/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.yaml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.ConfigurationOptions;
import me.lucko.helper.config.SimpleConfigurationNode;
import me.lucko.helper.config.loader.AbstractConfigurationLoader;
import me.lucko.helper.config.loader.CommentHandler;
import me.lucko.helper.config.loader.CommentHandlers;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YAMLConfigurationLoader
extends AbstractConfigurationLoader<ConfigurationNode> {
    private final ThreadLocal<Yaml> yaml;

    public static @NonNull Builder builder() {
        return new Builder();
    }

    private YAMLConfigurationLoader(Builder builder) {
        super(builder, new CommentHandler[]{CommentHandlers.HASH});
        DumperOptions opts = builder.options;
        this.yaml = ThreadLocal.withInitial(() -> new Yaml(opts));
    }

    @Override
    protected void loadInternal(ConfigurationNode node, BufferedReader reader) throws IOException {
        node.setValue(this.yaml.get().load((Reader)reader));
    }

    @Override
    protected void saveInternal(ConfigurationNode node, Writer writer) throws IOException {
        this.yaml.get().dump(node.getValue(), writer);
    }

    @Override
    public @NonNull ConfigurationNode createEmptyNode(@NonNull ConfigurationOptions options) {
        return SimpleConfigurationNode.root(options);
    }

    public static class Builder
    extends AbstractConfigurationLoader.Builder<Builder> {
        private final DumperOptions options = new DumperOptions();

        protected Builder() {
            this.setIndent(4);
        }

        public @NonNull Builder setIndent(int indent) {
            this.options.setIndent(indent);
            return this;
        }

        public int getIndent() {
            return this.options.getIndent();
        }

        public @NonNull Builder setFlowStyle(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull DumperOptions.FlowStyle style) {
            this.options.setDefaultFlowStyle(style);
            return this;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull DumperOptions.FlowStyle getFlowSyle() {
            return this.options.getDefaultFlowStyle();
        }

        @Override
        public @NonNull YAMLConfigurationLoader build() {
            return new YAMLConfigurationLoader(this);
        }
    }
}

