/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.text;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import me.lucko.helper.text.AbstractBuildableComponent;
import me.lucko.helper.text.Component;
import me.lucko.helper.text.event.ClickEvent;
import me.lucko.helper.text.event.HoverEvent;
import me.lucko.helper.text.format.TextColor;
import me.lucko.helper.text.format.TextDecoration;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TranslatableComponent
extends AbstractBuildableComponent<TranslatableComponent, Builder> {
    private final @NonNull String key;
    private final @NonNull List<Component> args;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@NonNull String key) {
        return new Builder().key(key);
    }

    public static TranslatableComponent of(@NonNull String key) {
        return TranslatableComponent.builder(key).build();
    }

    public static TranslatableComponent of(@NonNull String key, @Nullable TextColor color) {
        return ((Builder)TranslatableComponent.builder(key).color(color)).build();
    }

    public static TranslatableComponent of(@NonNull String key, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return ((Builder)((Builder)TranslatableComponent.builder(key).color(color)).decorations(decorations, true)).build();
    }

    public static TranslatableComponent of(@NonNull String key, Component ... args) {
        return TranslatableComponent.of(key, null, args);
    }

    public static TranslatableComponent of(@NonNull String key, @Nullable TextColor color, Component ... args) {
        return TranslatableComponent.of(key, color, Collections.emptySet(), args);
    }

    public static TranslatableComponent of(@NonNull String key, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations, Component ... args) {
        return TranslatableComponent.of(key, color, decorations, Arrays.asList(args));
    }

    public static TranslatableComponent of(@NonNull String key, @NonNull List<Component> args) {
        return TranslatableComponent.of(key, null, args);
    }

    public static TranslatableComponent of(@NonNull String key, @Nullable TextColor color, @NonNull List<Component> args) {
        return TranslatableComponent.of(key, color, Collections.emptySet(), args);
    }

    public static TranslatableComponent of(@NonNull String key, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations, @NonNull List<Component> args) {
        return ((Builder)((Builder)TranslatableComponent.builder().color(color)).decorations(decorations, true)).key(key).args(args).build();
    }

    public static TranslatableComponent make(@NonNull Consumer<Builder> consumer) {
        Builder builder = TranslatableComponent.builder();
        consumer.accept(builder);
        return builder.build();
    }

    public static TranslatableComponent make(@NonNull String key, @NonNull Consumer<Builder> consumer) {
        Builder builder = TranslatableComponent.builder(key);
        consumer.accept(builder);
        return builder.build();
    }

    public static TranslatableComponent make(@NonNull String key, @NonNull List<Component> args, @NonNull Consumer<Builder> consumer) {
        Builder builder = TranslatableComponent.builder(key).args(args);
        consumer.accept(builder);
        return builder.build();
    }

    protected TranslatableComponent(@NonNull Builder builder) {
        super(builder);
        this.key = builder.key;
        this.args = ImmutableList.copyOf((Collection)builder.args);
    }

    protected TranslatableComponent(@NonNull List<Component> children, @Nullable TextColor color, @NonNull TextDecoration.State obfuscated, @NonNull TextDecoration.State bold, @NonNull TextDecoration.State strikethrough, @NonNull TextDecoration.State underlined, @NonNull TextDecoration.State italic, @Nullable ClickEvent clickEvent, @Nullable HoverEvent hoverEvent, @Nullable String insertion, @NonNull String key, @NonNull List<Component> args) {
        super(children, color, obfuscated, bold, strikethrough, underlined, italic, clickEvent, hoverEvent, insertion);
        this.key = key;
        this.args = ImmutableList.copyOf(args);
    }

    public @NonNull String key() {
        return this.key;
    }

    public @NonNull TranslatableComponent key(@NonNull String key) {
        return new TranslatableComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, (String)Preconditions.checkNotNull((Object)key, (Object)"key"), this.args);
    }

    public @NonNull List<Component> args() {
        return Collections.unmodifiableList(this.args);
    }

    public @NonNull TranslatableComponent args(@NonNull List<Component> args) {
        return new TranslatableComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.key, args);
    }

    @Override
    public @NonNull TranslatableComponent append(@NonNull Component component) {
        this.detectCycle(component);
        ArrayList<Component> children = new ArrayList<Component>(this.children.size() + 1);
        children.addAll(this.children);
        children.add(component);
        return new TranslatableComponent(children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.key, this.args);
    }

    @Override
    public @NonNull TranslatableComponent color(@Nullable TextColor color) {
        return new TranslatableComponent(this.children, color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.key, this.args);
    }

    @Override
    public @NonNull TranslatableComponent decoration(@NonNull TextDecoration decoration, boolean flag) {
        return (TranslatableComponent)super.decoration(decoration, flag);
    }

    @Override
    public @NonNull TranslatableComponent decoration(@NonNull TextDecoration decoration, @NonNull TextDecoration.State state) {
        switch (decoration) {
            case BOLD: {
                return new TranslatableComponent(this.children, this.color, this.obfuscated, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.key, this.args);
            }
            case ITALIC: {
                return new TranslatableComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.clickEvent, this.hoverEvent, this.insertion, this.key, this.args);
            }
            case UNDERLINE: {
                return new TranslatableComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.key, this.args);
            }
            case STRIKETHROUGH: {
                return new TranslatableComponent(this.children, this.color, this.obfuscated, this.bold, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.key, this.args);
            }
            case OBFUSCATED: {
                return new TranslatableComponent(this.children, this.color, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.key, this.args);
            }
        }
        throw new IllegalArgumentException(String.format("unknown decoration '%s'", decoration));
    }

    @Override
    public @NonNull TranslatableComponent clickEvent(@Nullable ClickEvent event) {
        return new TranslatableComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, event, this.hoverEvent, this.insertion, this.key, this.args);
    }

    @Override
    public @NonNull TranslatableComponent hoverEvent(@Nullable HoverEvent event) {
        if (event != null) {
            this.detectCycle(event.value());
        }
        return new TranslatableComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, event, this.insertion, this.key, this.args);
    }

    @Override
    public @NonNull TranslatableComponent insertion(@Nullable String insertion) {
        return new TranslatableComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, insertion, this.key, this.args);
    }

    @Override
    public @NonNull TranslatableComponent mergeStyle(@NonNull Component that) {
        return new TranslatableComponent(this.children, that.color(), that.decoration(TextDecoration.OBFUSCATED), that.decoration(TextDecoration.BOLD), that.decoration(TextDecoration.STRIKETHROUGH), that.decoration(TextDecoration.UNDERLINE), that.decoration(TextDecoration.ITALIC), that.clickEvent(), that.hoverEvent(), that.insertion(), this.key, this.args);
    }

    @Override
    public @NonNull TranslatableComponent mergeColor(@NonNull Component that) {
        return new TranslatableComponent(this.children, that.color(), this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.key, this.args);
    }

    @Override
    public @NonNull TranslatableComponent mergeDecorations(@NonNull Component that) {
        TextDecoration.State obfuscated = that.decoration(TextDecoration.OBFUSCATED) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.OBFUSCATED) : this.obfuscated;
        TextDecoration.State bold = that.decoration(TextDecoration.BOLD) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.BOLD) : this.bold;
        TextDecoration.State strikethrough = that.decoration(TextDecoration.STRIKETHROUGH) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.STRIKETHROUGH) : this.strikethrough;
        TextDecoration.State underlined = that.decoration(TextDecoration.UNDERLINE) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.UNDERLINE) : this.underlined;
        TextDecoration.State italic = that.decoration(TextDecoration.ITALIC) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.ITALIC) : this.italic;
        return new TranslatableComponent(this.children, this.color, obfuscated, bold, strikethrough, underlined, italic, this.clickEvent, this.hoverEvent, this.insertion, this.key, this.args);
    }

    @Override
    public @NonNull TranslatableComponent mergeEvents(@NonNull Component that) {
        return new TranslatableComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, that.clickEvent(), that.hoverEvent(), this.insertion, this.key, this.args);
    }

    @Override
    public @NonNull TranslatableComponent resetStyle() {
        return new TranslatableComponent(this.children, null, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, null, null, null, this.key, this.args);
    }

    @Override
    public @NonNull TranslatableComponent copy() {
        return new TranslatableComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.key, this.args);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof TranslatableComponent)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        TranslatableComponent that = (TranslatableComponent)other;
        return Objects.equal((Object)this.key, (Object)that.key) && Objects.equal(this.args, that.args);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.key, this.args});
    }

    @Override
    protected void populateToString(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Objects.ToStringHelper builder) {
        builder.add("key", (Object)this.key).add("args", this.args);
    }

    @Override
    public @NonNull Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends AbstractBuildableComponent.AbstractBuilder<TranslatableComponent, Builder> {
        private @Nullable String key;
        private @NonNull List<Component> args = Component.EMPTY_COMPONENT_LIST;

        Builder() {
        }

        Builder(@NonNull TranslatableComponent component) {
            super(component);
            this.key = component.key();
            this.args = component.args();
        }

        public @NonNull Builder key(@NonNull String key) {
            this.key = key;
            return this;
        }

        public @NonNull Builder args(Component ... args) {
            return this.args(Arrays.asList(args));
        }

        public @NonNull Builder args(@NonNull List<Component> args) {
            this.args = args;
            return this;
        }

        @Override
        public @NonNull TranslatableComponent build() {
            Preconditions.checkState((this.key != null ? 1 : 0) != 0, (Object)"key must be set");
            return new TranslatableComponent(this);
        }
    }
}

