/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.command.argument;

import java.util.Optional;
import javax.annotation.Nonnull;
import me.lucko.helper.command.CommandInterruptException;
import me.lucko.helper.command.argument.Argument;
import me.lucko.helper.utils.annotation.NonnullByDefault;

@NonnullByDefault
public interface ArgumentParser<T> {
    public Optional<T> parse(@Nonnull String var1);

    @Nonnull
    default public T parseOrFail(@Nonnull String s) throws CommandInterruptException {
        Optional<T> ret = this.parse(s);
        if (!ret.isPresent()) {
            throw new CommandInterruptException("&cUnable to parse argument: " + s);
        }
        return ret.get();
    }

    @Nonnull
    default public Optional<T> parse(@Nonnull Argument argument) {
        return argument.value().flatMap(this::parse);
    }

    @Nonnull
    default public T parseOrFail(@Nonnull Argument argument) throws CommandInterruptException {
        Optional<T> ret = this.parse(argument);
        if (!ret.isPresent()) {
            throw new CommandInterruptException("&cUnable to parse argument at index " + argument.index() + ".");
        }
        return ret.get();
    }

    @Nonnull
    default public ArgumentParser<T> thenTry(@Nonnull ArgumentParser<T> other) {
        ArgumentParser first = this;
        return t -> {
            Optional ret = first.parse(t);
            return ret.isPresent() ? ret : other.parse(t);
        };
    }
}

