/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.text.serializer;

import com.google.common.collect.ObjectArrays;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lucko.helper.text.Component;
import me.lucko.helper.text.TextComponent;
import me.lucko.helper.text.format.TextColor;
import me.lucko.helper.text.format.TextDecoration;
import me.lucko.helper.text.format.TextFormat;
import me.lucko.helper.text.serializer.LegacyComponentSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Deprecated
class LegacyComponentSerializerImpl
implements LegacyComponentSerializer {
    private static final TextDecoration[] DECORATIONS = TextDecoration.values();
    private static final TextFormat[] FORMATS = (TextFormat[])ObjectArrays.concat((Object[])Stream.concat(Arrays.stream(TextColor.values()), Arrays.stream(DECORATIONS)).toArray(TextFormat[]::new), (Object)Reset.INSTANCE);
    private static final String FORMAT_LOOKUP = Arrays.stream(FORMATS).map(format -> String.valueOf(format.legacy())).collect(Collectors.joining());

    LegacyComponentSerializerImpl() {
    }

    @Override
    public @NonNull TextComponent deserialize(@NonNull String input, char character) {
        int next = input.lastIndexOf(character, input.length() - 2);
        if (next == -1) {
            return TextComponent.of(input);
        }
        ArrayList<TextComponent> parts = new ArrayList<TextComponent>();
        TextComponent.Builder current = null;
        boolean reset = false;
        int pos = input.length();
        do {
            TextFormat format;
            if ((format = LegacyComponentSerializerImpl.find(input.charAt(next + 1))) == null) continue;
            int from = next + 2;
            if (from != pos) {
                if (current != null) {
                    if (reset) {
                        parts.add(current.build());
                        reset = false;
                        current = TextComponent.builder("");
                    } else {
                        current = (TextComponent.Builder)TextComponent.builder("").append(current.build());
                    }
                } else {
                    current = TextComponent.builder("");
                }
                current.content(input.substring(from, pos));
            } else if (current == null) {
                current = TextComponent.builder("");
            }
            reset |= LegacyComponentSerializerImpl.applyFormat(current, format);
            pos = next;
        } while ((next = input.lastIndexOf(character, next - 1)) != -1);
        if (current != null) {
            parts.add(current.build());
        }
        Collections.reverse(parts);
        return ((TextComponent.Builder)TextComponent.builder(pos > 0 ? input.substring(0, pos) : "").append(parts)).build();
    }

    @Override
    public @NonNull String serialize(@NonNull Component component, char character) {
        Cereal state = new Cereal(character);
        state.append(component);
        return state.toString();
    }

    private static boolean applyFormat(@NonNull TextComponent.Builder builder, @NonNull TextFormat format) {
        if (format instanceof TextColor) {
            builder.colorIfAbsent((TextColor)format);
            return true;
        }
        if (format instanceof TextDecoration) {
            builder.decoration((TextDecoration)format, TextDecoration.State.TRUE);
            return false;
        }
        if (format instanceof Reset) {
            builder.colorIfAbsent(null);
            for (TextDecoration decoration : DECORATIONS) {
                builder.decoration(decoration, TextDecoration.State.NOT_SET);
            }
            return true;
        }
        throw new IllegalArgumentException(String.format("unknown format '%s'", format.getClass()));
    }

    private static TextFormat find(char legacy) {
        int pos = FORMAT_LOOKUP.indexOf(legacy);
        return pos == -1 ? null : FORMATS[pos];
    }

    @Deprecated
    private static final class Cereal {
        private final StringBuilder sb = new StringBuilder();
        private final Style style = new Style();
        private final char character;

        Cereal(char character) {
            this.character = character;
        }

        void append(@NonNull Component component) {
            this.append(component, new Style());
        }

        private void append(@NonNull Component component, @NonNull Style style) {
            List<Component> children;
            String content;
            style.apply(component);
            if (component instanceof TextComponent && !(content = ((TextComponent)component).content()).isEmpty()) {
                style.applyFormat();
                this.sb.append(content);
            }
            if (!(children = component.children()).isEmpty()) {
                Style childrenStyle = new Style(style);
                for (Component child : component.children()) {
                    this.append(child, childrenStyle);
                    childrenStyle.set(style);
                }
            }
        }

        private void append(@NonNull TextFormat format) {
            this.sb.append(this.character).append(format.legacy());
        }

        public String toString() {
            return this.sb.toString();
        }

        private final class Style {
            private @Nullable TextColor color;
            private final Set<TextDecoration> decorations;

            Style() {
                this.decorations = EnumSet.noneOf(TextDecoration.class);
            }

            Style(Style that) {
                this.color = that.color;
                this.decorations = EnumSet.copyOf(that.decorations);
            }

            void set(@NonNull Style that) {
                this.color = that.color;
                this.decorations.clear();
                this.decorations.addAll(that.decorations);
            }

            void apply(@NonNull Component component) {
                if (component.color() != null) {
                    this.color = component.color();
                }
                block4: for (TextDecoration decoration : DECORATIONS) {
                    switch (component.decoration(decoration)) {
                        case TRUE: {
                            this.decorations.add(decoration);
                            continue block4;
                        }
                        case FALSE: {
                            this.decorations.remove(decoration);
                        }
                    }
                }
            }

            void applyFormat() {
                if (this.color != ((Cereal)Cereal.this).style.color) {
                    this.applyFullFormat();
                    return;
                }
                if (!this.decorations.containsAll(((Cereal)Cereal.this).style.decorations)) {
                    this.applyFullFormat();
                    return;
                }
                for (TextDecoration decoration : this.decorations) {
                    if (!((Cereal)Cereal.this).style.decorations.add(decoration)) continue;
                    Cereal.this.append(decoration);
                }
            }

            private void applyFullFormat() {
                if (this.color != null) {
                    Cereal.this.append(this.color);
                    ((Cereal)Cereal.this).style.color = this.color;
                } else {
                    Cereal.this.append(Reset.INSTANCE);
                }
                for (TextDecoration decoration : this.decorations) {
                    Cereal.this.append(decoration);
                }
                ((Cereal)Cereal.this).style.decorations.clear();
                ((Cereal)Cereal.this).style.decorations.addAll(this.decorations);
            }
        }
    }

    @Deprecated
    private static enum Reset implements TextFormat
    {
        INSTANCE;


        @Override
        @Deprecated
        public char legacy() {
            return 'r';
        }
    }
}

