/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.reflect.proxy;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import javax.annotation.Nonnull;

public final class Proxies {
    @Nonnull
    public static <T> T create(@Nonnull Class<T> interfaceType, @Nonnull InvocationHandler handler) {
        return Proxies.create(interfaceType.getClassLoader(), interfaceType, handler);
    }

    @Nonnull
    public static <T> T create(@Nonnull ClassLoader loader, @Nonnull Class<T> interfaceType, @Nonnull InvocationHandler handler) {
        return interfaceType.cast(Proxies.create(loader, new Class[]{interfaceType}, handler));
    }

    @Nonnull
    public static <T> T create(@Nonnull ClassLoader loader, @Nonnull Class<T> interfaceType, @Nonnull List<Class<?>> interfaces, @Nonnull InvocationHandler handler) {
        return Proxies.create(loader, interfaceType, interfaces.toArray(new Class[interfaces.size()]), handler);
    }

    @Nonnull
    public static <T> T create(@Nonnull ClassLoader loader, @Nonnull Class<T> interfaceType, @Nonnull Class<?>[] interfaces, @Nonnull InvocationHandler handler) {
        return interfaceType.cast(Proxies.create(loader, Lists.asList(interfaceType, (Object[])interfaces), handler));
    }

    @Nonnull
    public static Object create(@Nonnull ClassLoader loader, @Nonnull List<Class<?>> interfaces, @Nonnull InvocationHandler handler) {
        return Proxies.create(loader, interfaces.toArray(new Class[interfaces.size()]), handler);
    }

    @Nonnull
    public static Object create(@Nonnull ClassLoader loader, @Nonnull Class<?>[] interfaces, @Nonnull InvocationHandler handler) {
        return Proxy.newProxyInstance(loader, interfaces, handler);
    }

    private Proxies() {
    }
}

