/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.gson.typeadapters;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public final class BukkitSerializableAdapterFactory
implements TypeAdapterFactory {
    public static final BukkitSerializableAdapterFactory INSTANCE = new BukkitSerializableAdapterFactory();

    private BukkitSerializableAdapterFactory() {
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class clazz = type.getRawType();
        if (!ConfigurationSerializable.class.isAssignableFrom(clazz)) {
            return null;
        }
        return new Adapter(gson);
    }

    private static final class Adapter
    extends TypeAdapter<ConfigurationSerializable> {
        private static final Type RAW_OUTPUT_TYPE = new TypeToken<Map<String, Object>>(){}.getType();
        private final Gson gson;

        private Adapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter out, ConfigurationSerializable value) {
            Map serialized = value.serialize();
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(serialized.size() + 1);
            map.put("==", ConfigurationSerialization.getAlias(value.getClass()));
            map.putAll(serialized);
            this.gson.toJson(map, RAW_OUTPUT_TYPE, out);
        }

        public ConfigurationSerializable read(JsonReader in) {
            Map map = (Map)this.gson.fromJson(in, RAW_OUTPUT_TYPE);
            this.deserializeChildren(map);
            return ConfigurationSerialization.deserializeObject((Map)map);
        }

        private void deserializeChildren(Map<String, Object> map) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getValue() instanceof Map) {
                    try {
                        Map value = (Map)entry.getValue();
                        this.deserializeChildren(value);
                        if (value.containsKey("==")) {
                            entry.setValue(ConfigurationSerialization.deserializeObject((Map)value));
                        }
                    }
                    catch (Exception value) {
                        // empty catch block
                    }
                }
                if (!(entry.getValue() instanceof Number)) continue;
                double doubleVal = ((Number)entry.getValue()).doubleValue();
                int intVal = (int)doubleVal;
                long longVal = (long)doubleVal;
                if ((double)intVal == doubleVal) {
                    entry.setValue(intVal);
                    continue;
                }
                if ((double)longVal == doubleVal) {
                    entry.setValue(longVal);
                    continue;
                }
                entry.setValue(doubleVal);
            }
        }
    }
}

