/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.command;

import java.util.Arrays;
import javax.annotation.Nullable;
import me.lucko.helper.command.Command;
import me.lucko.helper.command.CommandInterruptException;
import me.lucko.helper.command.context.ImmutableCommandContext;
import me.lucko.helper.internal.LoaderUtils;
import me.lucko.helper.timings.MCTiming;
import me.lucko.helper.timings.Timings;
import me.lucko.helper.utils.CommandMapUtil;
import me.lucko.helper.utils.annotation.NonnullByDefault;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

@NonnullByDefault
public abstract class AbstractCommand
implements Command,
CommandExecutor {
    @Nullable
    private MCTiming timing = null;

    @Override
    public void register(String ... aliases) {
        LoaderUtils.getPlugin().registerCommand(this, aliases);
        this.timing = Timings.of("helper-commands: " + Arrays.toString(aliases));
    }

    @Override
    public void close() {
        CommandMapUtil.unregisterCommand(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onCommand(CommandSender sender, org.bukkit.command.Command command, String label, String[] args) {
        try {
            if (this.timing != null) {
                this.timing.startTiming();
            }
            ImmutableCommandContext<CommandSender> context = new ImmutableCommandContext<CommandSender>(sender, label, args);
            try {
                this.call(context);
            }
            catch (CommandInterruptException e) {
                e.getAction().accept((CommandSender)context.sender());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.timing != null) {
                this.timing.stopTiming();
            }
        }
    }
}

