/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.text.event;

import com.google.common.base.Enums;
import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import me.lucko.helper.text.Component;
import net.kyori.blizzard.NonNull;

public final class HoverEvent {
    @NonNull
    private final Action action;
    @NonNull
    private final Component value;

    public HoverEvent(@NonNull Action action, @NonNull Component value) {
        this.action = action;
        this.value = value;
    }

    @NonNull
    public Action action() {
        return this.action;
    }

    @NonNull
    public Component value() {
        return this.value;
    }

    @NonNull
    public HoverEvent copy() {
        return new HoverEvent(this.action, this.value.copy());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HoverEvent that = (HoverEvent)other;
        return this.action == that.action && Objects.equal((Object)this.value, (Object)that.value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.action, this.value});
    }

    @NonNull
    public String toString() {
        return Objects.toStringHelper((Object)this).add("action", (Object)this.action).add("value", (Object)this.value).toString();
    }

    public static enum Action {
        SHOW_TEXT(true),
        SHOW_ITEM(true),
        SHOW_ENTITY(true);

        @NonNull
        private final String toString = Enums.getField((Enum)this).getAnnotation(SerializedName.class).value();
        private final boolean readable;

        private Action(boolean readable) {
            this.readable = readable;
        }

        public boolean isReadable() {
            return this.readable;
        }

        @NonNull
        public String toString() {
            return this.toString;
        }
    }
}

