/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.text;

import java.util.function.Consumer;
import java.util.function.Function;
import me.lucko.helper.text.Component;
import me.lucko.helper.text.event.ClickEvent;
import me.lucko.helper.text.event.HoverEvent;
import me.lucko.helper.text.format.TextColor;
import me.lucko.helper.text.format.TextDecoration;
import net.kyori.blizzard.NonNull;
import net.kyori.blizzard.Nullable;

public interface BuildableComponent<C extends BuildableComponent<C, B>, B extends Builder<C, B>>
extends Component {
    @NonNull
    public B toBuilder();

    public static interface Builder<C extends BuildableComponent, B extends Builder<C, B>> {
        @NonNull
        public B append(@NonNull Component var1);

        @NonNull
        public B append(@NonNull Iterable<? extends Component> var1);

        @NonNull
        default public B apply(@NonNull Consumer<Builder<?, ?>> consumer) {
            consumer.accept(this);
            return (B)this;
        }

        @NonNull
        public B applyDeep(@NonNull Consumer<Builder<?, ?>> var1);

        @NonNull
        public B mapChildren(@NonNull Function<BuildableComponent<?, ?>, BuildableComponent<?, ?>> var1);

        @NonNull
        public B mapChildrenDeep(@NonNull Function<BuildableComponent<?, ?>, BuildableComponent<?, ?>> var1);

        @NonNull
        public B color(@Nullable TextColor var1);

        @NonNull
        public B colorIfAbsent(@Nullable TextColor var1);

        @NonNull
        default public B decoration(@NonNull TextDecoration decoration, boolean flag) {
            return this.decoration(decoration, TextDecoration.State.byBoolean(flag));
        }

        @NonNull
        public B decoration(@NonNull TextDecoration var1, @NonNull TextDecoration.State var2);

        @NonNull
        public B clickEvent(@Nullable ClickEvent var1);

        @NonNull
        public B hoverEvent(@Nullable HoverEvent var1);

        @NonNull
        public B insertion(@Nullable String var1);

        @NonNull
        default public B mergeStyle(@NonNull Component that) {
            this.mergeColor(that);
            this.mergeDecorations(that);
            this.mergeEvents(that);
            return (B)this;
        }

        @NonNull
        default public B mergeColor(@NonNull Component that) {
            if (that.color() != null) {
                this.color(that.color());
            }
            return (B)this;
        }

        @NonNull
        default public B mergeDecorations(@NonNull Component that) {
            for (TextDecoration decoration : TextDecoration.values()) {
                TextDecoration.State state = that.decoration(decoration);
                if (state == TextDecoration.State.NOT_SET) continue;
                this.decoration(decoration, state);
            }
            return (B)this;
        }

        @NonNull
        default public B mergeEvents(@NonNull Component that) {
            if (that.clickEvent() != null) {
                this.clickEvent(that.clickEvent());
            }
            if (that.hoverEvent() != null) {
                this.hoverEvent(that.hoverEvent().copy());
            }
            return (B)this;
        }

        @NonNull
        default public B resetStyle() {
            this.color(null);
            for (TextDecoration decoration : TextDecoration.values()) {
                this.decoration(decoration, TextDecoration.State.NOT_SET);
            }
            this.clickEvent(null);
            this.hoverEvent(null);
            return (B)this;
        }

        @NonNull
        public C build();
    }
}

