/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.shadow;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.annotation.Nullable;
import me.lucko.helper.reflect.proxy.MoreMethodHandles;
import me.lucko.helper.shadow.FieldMethodHandle;
import me.lucko.helper.shadow.ShadowDefinition;
import me.lucko.helper.shadow.ShadowFactory;
import me.lucko.helper.shadow.model.Shadow;
import me.lucko.helper.shadow.model.ShadowField;
import me.lucko.helper.shadow.model.ShadowMethod;
import me.lucko.helper.shadow.model.Static;

final class ShadowInvocationHandler
implements InvocationHandler {
    private final ShadowFactory shadowFactory;
    private final ShadowDefinition shadow;
    @Nullable
    private final Object handle;

    ShadowInvocationHandler(ShadowFactory shadowFactory, ShadowDefinition shadow, @Nullable Object handle) {
        this.shadowFactory = shadowFactory;
        this.shadow = shadow;
        this.handle = handle;
    }

    @Override
    public Object invoke(Object shadowInstance, Method shadowMethod, Object[] args) throws Throwable {
        if (shadowMethod.getName().equals("getShadowTarget")) {
            return this.handle;
        }
        if (shadowMethod.isDefault()) {
            Class<?> declaringClass = shadowMethod.getDeclaringClass();
            return MoreMethodHandles.privateLookupIn(declaringClass).unreflectSpecial(shadowMethod, declaringClass).bindTo(shadowInstance).invokeWithArguments(args);
        }
        ShadowMethod methodAnnotation = shadowMethod.getAnnotation(ShadowMethod.class);
        if (methodAnnotation != null || shadowMethod.getDeclaringClass() == Object.class) {
            Object[] unwrappedArguments = this.shadowFactory.unwrapShadows(args);
            Class[] unwrappedArgumentTypes = (Class[])Arrays.stream(unwrappedArguments).map(Object::getClass).toArray(Class[]::new);
            MethodHandle targetMethod = this.shadow.findTargetMethod(shadowMethod, unwrappedArgumentTypes);
            Object handle = this.getHandle(shadowMethod);
            Object returnObject = handle == null ? targetMethod.invokeWithArguments(unwrappedArguments) : targetMethod.bindTo(handle).invokeWithArguments(unwrappedArguments);
            if (returnObject == null) {
                return null;
            }
            if (shadowMethod.getName().equals("toString") && shadowMethod.getParameterCount() == 0) {
                return "Shadow(shadowClass=" + this.shadow.getShadowClass() + ", targetClass=" + this.shadow.getTargetClass() + ", target=" + returnObject + ")";
            }
            if (Shadow.class.isAssignableFrom(shadowMethod.getReturnType())) {
                returnObject = this.shadowFactory.createShadowProxy(shadowMethod.getReturnType(), returnObject);
            }
            return returnObject;
        }
        ShadowField fieldAnnotation = shadowMethod.getAnnotation(ShadowField.class);
        if (fieldAnnotation != null) {
            FieldMethodHandle targetField = this.shadow.findTargetField(shadowMethod);
            if (args == null || args.length == 0) {
                MethodHandle getter = targetField.getGetter();
                Object handle = this.getHandle(shadowMethod);
                Object value = handle == null ? getter.invoke() : getter.bindTo(handle).invoke();
                if (Shadow.class.isAssignableFrom(shadowMethod.getReturnType())) {
                    value = this.shadowFactory.createShadowProxy(shadowMethod.getReturnType(), value);
                }
                return value;
            }
            if (args.length == 1) {
                MethodHandle setter = targetField.getSetter();
                Object handle = this.getHandle(shadowMethod);
                Object value = this.shadowFactory.unwrapShadow(args[0]);
                if (handle == null) {
                    setter.invokeWithArguments(value);
                } else {
                    setter.bindTo(handle).invokeWithArguments(value);
                }
                if (shadowMethod.getReturnType() == Void.TYPE) {
                    return null;
                }
                return this.handle;
            }
            throw new IllegalStateException("Unable to determine accessor type (getter/setter) for " + this.shadow.getTargetClass().getName() + "#" + shadowMethod.getName());
        }
        throw new RuntimeException("Shadow method " + shadowMethod + " is not marked with @ShadowMethod or @ShadowField");
    }

    @Nullable
    private Object getHandle(AnnotatedElement annotatedElement) {
        return annotatedElement.getAnnotation(Static.class) != null ? null : this.handle;
    }
}

