/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.shadow;

import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import me.lucko.helper.reflect.proxy.Proxies;
import me.lucko.helper.shadow.ShadowDefinition;
import me.lucko.helper.shadow.ShadowInvocationHandler;
import me.lucko.helper.shadow.model.Shadow;
import me.lucko.helper.shadow.model.ShadowClass;
import me.lucko.helper.shadow.model.transformer.NmsTransformer;
import me.lucko.helper.shadow.model.transformer.ObcTransformer;
import me.lucko.helper.shadow.model.transformer.ShadowTransformer;

public final class ShadowFactory {
    private static final ShadowFactory INSTANCE = new ShadowFactory();
    private final Map<Class<? extends Shadow>, ShadowDefinition> shadows = new ConcurrentHashMap<Class<? extends Shadow>, ShadowDefinition>();

    public static <T extends Shadow> T shadow(Class<T> shadowClass, Object handle) {
        return INSTANCE.createShadowProxy(shadowClass, handle);
    }

    public static <T extends Shadow> T staticShadow(Class<T> shadowClass) {
        return INSTANCE.createStaticShadowProxy(shadowClass);
    }

    public static <T extends Shadow> T constructShadow(Class<T> shadowClass, Object ... arguments) {
        return INSTANCE.constructShadowInstance(shadowClass, arguments);
    }

    private ShadowFactory() {
    }

    public <T extends Shadow> T createShadowProxy(Class<T> shadowClass, Object handle) {
        Objects.requireNonNull(shadowClass, "shadowClass");
        Objects.requireNonNull(handle, "handle");
        ShadowDefinition shadowDefinition = this.registerShadow(shadowClass);
        Class<?> targetClass = this.shadows.get(shadowClass).getTargetClass();
        if (!targetClass.isAssignableFrom(handle.getClass())) {
            throw new IllegalArgumentException("Target class " + targetClass.getName() + " is not assignable from handle class " + handle.getClass().getName());
        }
        return (T)((Shadow)Proxies.create(shadowClass, new ShadowInvocationHandler(this, shadowDefinition, handle)));
    }

    public <T extends Shadow> T createStaticShadowProxy(Class<T> shadowClass) {
        Objects.requireNonNull(shadowClass, "shadowClass");
        ShadowDefinition shadowDefinition = this.registerShadow(shadowClass);
        return (T)((Shadow)Proxies.create(shadowClass, new ShadowInvocationHandler(this, shadowDefinition, null)));
    }

    public <T extends Shadow> T constructShadowInstance(Class<T> shadowClass, Object ... args) {
        Object newInstance;
        Objects.requireNonNull(shadowClass, "shadowClass");
        ShadowDefinition shadowDefinition = this.registerShadow(shadowClass);
        Object[] unwrappedArguments = this.unwrapShadows(args);
        Class[] unwrappedArgumentTypes = (Class[])Arrays.stream(unwrappedArguments).map(Object::getClass).toArray(Class[]::new);
        MethodHandle targetConstructor = shadowDefinition.findTargetConstructor(unwrappedArgumentTypes);
        try {
            newInstance = targetConstructor.invokeWithArguments(unwrappedArguments);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return this.createShadowProxy(shadowClass, newInstance);
    }

    private ShadowDefinition registerShadow(Class<? extends Shadow> c) {
        return this.shadows.computeIfAbsent(c, shadowClass -> {
            Class<?> targetClass;
            ShadowTransformer transformer;
            ShadowClass annotation = shadowClass.getAnnotation(ShadowClass.class);
            if (annotation == null) {
                throw new IllegalStateException("Shadow class " + shadowClass.getName() + " does not have a @ShadowClass annotation present.");
            }
            Class<? extends ShadowTransformer> transformerClass = annotation.transformer();
            if (transformerClass == ShadowTransformer.class) {
                transformer = null;
            } else if (transformerClass == NmsTransformer.class) {
                transformer = NmsTransformer.INSTANCE;
            } else if (transformerClass == ObcTransformer.class) {
                transformer = ObcTransformer.INSTANCE;
            } else {
                try {
                    transformer = transformerClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("Unable to init transformer " + transformerClass.getName(), e);
                }
            }
            String targetClassName = annotation.className();
            if (transformer != null) {
                targetClassName = transformer.transformClassName(targetClassName);
            }
            try {
                targetClass = Class.forName(targetClassName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class " + targetClassName + " not found for shadow " + shadowClass.getName());
            }
            return new ShadowDefinition((Class<? extends Shadow>)shadowClass, targetClass);
        });
    }

    Object[] unwrapShadows(Object[] objects) {
        if (objects == null) {
            return new Object[0];
        }
        return Arrays.stream(objects).map(this::unwrapShadow).toArray(Object[]::new);
    }

    Object unwrapShadow(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Shadow) {
            this.registerShadow(object.getClass());
            return ((Shadow)object).getShadowTarget();
        }
        return object;
    }
}

