/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.shadow;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

final class BeanUtils {
    private BeanUtils() {
    }

    public static Method getMatchingMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method;
        }
        catch (NoSuchMethodException method) {
            int paramSize = parameterTypes.length;
            Method bestMatch = null;
            float bestMatchCost = Float.MAX_VALUE;
            for (Method method2 : clazz.getDeclaredMethods()) {
                float myCost;
                Class<?>[] methodsParams;
                int methodParamSize;
                if (!method2.getName().equals(methodName) || (methodParamSize = (methodsParams = method2.getParameterTypes()).length) != paramSize) continue;
                boolean match = true;
                for (int n = 0; n < methodParamSize; ++n) {
                    if (BeanUtils.isAssignmentCompatible(methodsParams[n], parameterTypes[n])) continue;
                    match = false;
                    break;
                }
                if (!match || !((myCost = BeanUtils.getTotalTransformationCost(parameterTypes, method2.getParameterTypes())) < bestMatchCost)) continue;
                bestMatch = method2;
                bestMatchCost = myCost;
            }
            if (bestMatch == null && clazz.getSuperclass() != null) {
                bestMatch = BeanUtils.getMatchingMethod(clazz.getSuperclass(), methodName, parameterTypes);
            }
            if (bestMatch == null && clazz.getInterfaces() != null) {
                Class<?> i;
                Class<?>[] interfaces;
                Class<?>[] classArray = interfaces = clazz.getInterfaces();
                int n = classArray.length;
                for (int j = 0; j < n && (bestMatch = BeanUtils.getMatchingMethod(i = classArray[j], methodName, parameterTypes)) == null; ++j) {
                }
            }
            return bestMatch;
        }
    }

    public static Constructor<?> getMatchingConstructor(Class<?> clazz, Class<?>[] parameterTypes) {
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(parameterTypes);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        catch (NoSuchMethodException constructor) {
            int paramSize = parameterTypes.length;
            Constructor<?> bestMatch = null;
            float bestMatchCost = Float.MAX_VALUE;
            for (Constructor<?> constructor2 : clazz.getDeclaredConstructors()) {
                float myCost;
                Class<?>[] methodsParams = constructor2.getParameterTypes();
                int methodParamSize = methodsParams.length;
                if (methodParamSize != paramSize) continue;
                boolean match = true;
                for (int n = 0; n < methodParamSize; ++n) {
                    if (BeanUtils.isAssignmentCompatible(methodsParams[n], parameterTypes[n])) continue;
                    match = false;
                    break;
                }
                if (!match || !((myCost = BeanUtils.getTotalTransformationCost(parameterTypes, constructor2.getParameterTypes())) < bestMatchCost)) continue;
                bestMatch = constructor2;
                bestMatchCost = myCost;
            }
            return bestMatch;
        }
    }

    private static float getTotalTransformationCost(Class<?>[] srcArgs, Class<?>[] destArgs) {
        float totalCost = 0.0f;
        for (int i = 0; i < srcArgs.length; ++i) {
            Class<?> srcClass = srcArgs[i];
            Class<?> destClass = destArgs[i];
            totalCost += BeanUtils.getObjectTransformationCost(srcClass, destClass);
        }
        return totalCost;
    }

    private static float getObjectTransformationCost(Class<?> srcClass, Class<?> destClass) {
        float cost = 0.0f;
        while (srcClass != null && !destClass.equals(srcClass)) {
            Class<?> destClassWrapperClazz;
            if (destClass.isPrimitive() && (destClassWrapperClazz = BeanUtils.getPrimitiveWrapper(destClass)) != null && destClassWrapperClazz.equals(srcClass)) {
                cost += 0.25f;
                break;
            }
            if (destClass.isInterface() && BeanUtils.isAssignmentCompatible(destClass, srcClass)) {
                cost += 0.25f;
                break;
            }
            cost += 1.0f;
            srcClass = srcClass.getSuperclass();
        }
        if (srcClass == null) {
            cost += 1.5f;
        }
        return cost;
    }

    private static boolean isAssignmentCompatible(Class<?> parameterType, Class<?> parameterization) {
        Class<?> parameterWrapperClazz;
        if (parameterType.isAssignableFrom(parameterization)) {
            return true;
        }
        if (parameterType.isPrimitive() && (parameterWrapperClazz = BeanUtils.getPrimitiveWrapper(parameterType)) != null) {
            return parameterWrapperClazz.equals(parameterization);
        }
        return false;
    }

    private static Class<?> getPrimitiveWrapper(Class<?> primitiveType) {
        if (Boolean.TYPE.equals(primitiveType)) {
            return Boolean.class;
        }
        if (Float.TYPE.equals(primitiveType)) {
            return Float.class;
        }
        if (Long.TYPE.equals(primitiveType)) {
            return Long.class;
        }
        if (Integer.TYPE.equals(primitiveType)) {
            return Integer.class;
        }
        if (Short.TYPE.equals(primitiveType)) {
            return Short.class;
        }
        if (Byte.TYPE.equals(primitiveType)) {
            return Byte.class;
        }
        if (Double.TYPE.equals(primitiveType)) {
            return Double.class;
        }
        if (Character.TYPE.equals(primitiveType)) {
            return Character.class;
        }
        return null;
    }
}

