/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.serialize;

import com.flowpowered.math.vector.Vector3d;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.gson.GsonSerializable;
import me.lucko.helper.gson.JsonBuilder;
import me.lucko.helper.serialize.Direction;
import me.lucko.helper.serialize.Point;
import me.lucko.helper.serialize.Position;
import me.lucko.helper.serialize.VectorSerializers;
import org.bukkit.Location;
import org.bukkit.World;

public final class VectorPoint
implements GsonSerializable {
    private final Vector3d position;
    private final Direction direction;
    @Nullable
    private Location bukkitLocation = null;

    public static VectorPoint deserialize(JsonElement element) {
        Vector3d position = VectorSerializers.deserialize3d(element);
        Direction direction = Direction.deserialize(element);
        return VectorPoint.of(position, direction);
    }

    public static VectorPoint of(Vector3d position, Direction direction) {
        Objects.requireNonNull(position, "position");
        Objects.requireNonNull(direction, "direction");
        return new VectorPoint(position, direction);
    }

    public static VectorPoint of(Location location) {
        Objects.requireNonNull(location, "location");
        return VectorPoint.of(Position.of(location).toVector(), Direction.from(location));
    }

    public static VectorPoint of(Point point) {
        Objects.requireNonNull(point, "point");
        return VectorPoint.of(point.getPosition().toVector(), point.getDirection());
    }

    private VectorPoint(Vector3d position, Direction direction) {
        this.position = position;
        this.direction = direction;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public synchronized Location toLocation(World world) {
        if (this.bukkitLocation == null) {
            this.bukkitLocation = new Location(world, this.position.getX(), this.position.getY(), this.position.getZ(), this.direction.getYaw(), this.direction.getPitch());
        }
        return this.bukkitLocation.clone();
    }

    public VectorPoint add(double x, double y, double z) {
        return VectorPoint.of(this.position.add(x, y, z), this.direction);
    }

    public VectorPoint subtract(double x, double y, double z) {
        return VectorPoint.of(this.position.sub(x, y, z), this.direction);
    }

    public Point withWorld(String world) {
        Objects.requireNonNull(world, "world");
        return Point.of(Position.of(this.position, world), this.direction);
    }

    @Nonnull
    public JsonObject serialize() {
        return JsonBuilder.object().addAll(VectorSerializers.serialize(this.position)).addAll(this.direction.serialize()).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VectorPoint)) {
            return false;
        }
        VectorPoint other = (VectorPoint)o;
        return this.getPosition().equals(other.getPosition()) && this.getDirection().equals(other.getDirection());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPosition().hashCode();
        result = result * 59 + this.getDirection().hashCode();
        return result;
    }

    public String toString() {
        return "VectorPoint(position=" + this.getPosition() + ", direction=" + this.getDirection() + ")";
    }
}

