/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.reflect.proxy;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;

public final class MoreMethodHandles {
    private static final Constructor<MethodHandles.Lookup> LOOKUP_CONSTRUCTOR;
    private static final LoadingCache<Class<?>, MethodHandles.Lookup> LOOKUPS;
    public static final int TRUSTED_FLAG = -1;

    @Nonnull
    public static MethodHandles.Lookup privateLookupIn(@Nonnull Class<?> targetClass) {
        return (MethodHandles.Lookup)LOOKUPS.getUnchecked(targetClass);
    }

    @Nonnull
    public static MethodHandle unreflect(@Nonnull Class<?> targetClass, @Nonnull Method method) {
        try {
            return MoreMethodHandles.privateLookupIn(targetClass).unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static MethodHandle unreflect(@Nonnull Method method) {
        return MoreMethodHandles.unreflect(method.getDeclaringClass(), method);
    }

    @Nonnull
    public static MethodHandle unreflect(@Nonnull Class<?> targetClass, @Nonnull Constructor constructor) {
        try {
            return MoreMethodHandles.privateLookupIn(targetClass).unreflectConstructor(constructor);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static MethodHandle unreflect(@Nonnull Constructor constructor) {
        return MoreMethodHandles.unreflect(constructor.getDeclaringClass(), constructor);
    }

    @Nonnull
    public static MethodHandle unreflectGetter(@Nonnull Class<?> targetClass, @Nonnull Field field) {
        try {
            return MoreMethodHandles.privateLookupIn(targetClass).unreflectGetter(field);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static MethodHandle unreflectGetter(@Nonnull Field field) {
        return MoreMethodHandles.unreflectGetter(field.getDeclaringClass(), field);
    }

    @Nonnull
    public static MethodHandle unreflectSetter(@Nonnull Class<?> targetClass, @Nonnull Field field) {
        try {
            return MoreMethodHandles.privateLookupIn(targetClass).unreflectSetter(field);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static MethodHandle unreflectSetter(@Nonnull Field field) {
        return MoreMethodHandles.unreflectSetter(field.getDeclaringClass(), field);
    }

    static {
        try {
            LOOKUP_CONSTRUCTOR = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
            LOOKUP_CONSTRUCTOR.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
        LOOKUPS = CacheBuilder.newBuilder().build(CacheLoader.from(requestedLookupClass -> {
            try {
                return LOOKUP_CONSTRUCTOR.newInstance(requestedLookupClass, 15);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }));
    }
}

